/*
   szic floatimgpoint_morenums
   Szkic inicjalizuje zmienną zmiennoprzecinkową o wartości 1.1
   Następnie stopniowo ją zmniejsza o 0.1 dopóki nie osiągnie wartości 0
*/

float value = 1.1;


void setup()
{
  Serial.begin(9600);
}

void loop()
{
  testPrecision(1.1, 0);
  testPrecision(11.1, 10);
  testPrecision(101.1, 100);
  testPrecision(1001.1, 1000);
  delay(2500);
}

void testPrecision(float a, float b)
{
  float decrement = 0.1;
  while (a >= b - decrement) {
    if (almostEqual(a, b)) {
      Serial.print("Wartość ");
      Serial.print(a, 7); // wyświetl do 7 miejsc po przecinku
      Serial.print(" jest niemal równa z ");
      Serial.println(b, 7); // wyświetl do 7 miejsc po przecinku
    }
    a = a - decrement;
  }
}

// zwraca true, gdy różnica między a i b jest mała
int almostEqual(float a, float b)
{
  const float DELTA = .00001; //  maksymalna różnica, aby wartości były niemal równe 

  if (a == 0) return fabs(b) <= DELTA;
  if (b == 0) return fabs(a) <= DELTA;

  float diff_unscaled = fabs(a - b);
  float diff_scaled   = fabs((a - b) / max(fabs(a), fabs(b)));
  if (diff_scaled <= DELTA)
  {
    Serial.print("Nieprzeskalowana: ");
    Serial.print(diff_unscaled, 7);
    Serial.print(" Przeskalowana: ");
    Serial.println(diff_scaled, 7);
    return 1;
  }
  return 0;
}
