/*
 * Szkic conditional_compile
 * Ten szkic rozpoznaje mikrokontroler za pomocą wyrażeń warunkowych preprocesora
 */

int numberOfSensors;
int val = 0;               // Zmienna przechowująca wartość odczytaną z czujnika

void setup()
{
  Serial.begin(9600);

#if defined(__AVR_ATmega2560__)   // Kod kompilowany w przypadku, gdy w Arduino IDE wybrana jest płytka Mega
  numberOfSensors = 16;           // Liczba analogowych pinów wejścia płytki Mega
  #pragma message ( "Użycie 16 czujników" )
#else                             // Kod kompilowany w przypadku wybrania innej płytki (z założenia została wybrana płytka standardowa)
  numberOfSensors = 6;            // Liczba analogowych pinów wejścia standardowej płytki Arduino
  #pragma message ( "Użycie 6 czujników" )
#endif

  Serial.print("Liczba czujników to ");
  Serial.println(numberOfSensors);
}

void loop() {
  for(int sensor = 0; sensor < numberOfSensors; sensor++)
  {
    val = analogRead(sensor);    // Odczyt wartości czujnika
    Serial.print(sensor); Serial.print(": ");
    Serial.println(val);         // Wyświetlanie wartości
  }
  Serial.println();
  delay(1000);        // Przerwa między kolejnymi odczytami
}
