/*
 * Szkic classic_bluetooth
 * Użyj SoftwareSerial lub Serial1, aby komunikować się z modułem BlueSMiRF
 * Kod dla połączenia urządzeń to 1234
 */

//#define USESERIAL1 // Usuń znaczniki komentarza sprzed tej linijki, jeśli używasz Leonardo lub innej płytki Arm
#ifdef USESERIAL1
  #define BTSERIAL Serial1
#else
  #include <SoftwareSerial.h>
  const int rxpin = 2;  // Pin odbierający
  const int txpin = 3;  // Pin wysyłający
  SoftwareSerial mySerial(rxpin, txpin); // Nowy port szeregowy na podanych pinach
  #define BTSERIAL mySerial // Programowy port szeregowy
#endif

void setup()
{
  Serial.begin(9600);  
  BTSERIAL.begin(9600); // Inicjalizacja programowego portu szeregowego
  Serial.println("Port szeregowy jest gotowy");
  BTSERIAL.println("Bluetooth jest gotowy");  
}

void loop()
{
  if (BTSERIAL.available())
  {
    char c = (char)BTSERIAL.read();
    Serial.write(c);
  }
  if (Serial.available())
  {
    char c = (char)Serial.read();
    BTSERIAL.write(c);
  }
}
