/*
 * Szkic BLE
 * Umożliwia sterowanie diodą LED przez Bluetooth Low Energy
 */

#include <ArduinoBLE.h>

#define SERVICE_ID "19B10010-E8F2-537E-4F6C-D104768A1214"
#define CHAR_ID    "19B10011-E8F2-537E-4F6C-D104768A1214"

// Utworzenie ID usługi i jej charakterystyki (odczyt-zapis)
BLEService ledService(SERVICE_ID); 
BLEByteCharacteristic ledCharacteristic(CHAR_ID, BLERead | BLEWrite); 
BLEDescriptor ledDescriptor("2901", "LED state");

void setup() 
{
  Serial.begin(9600);
  pinMode(LED_BUILTIN, OUTPUT);

  if (!BLE.begin()) 
  {
    Serial.println("Nie udało się uruchomić modułu BLE");
    while (1); // Zatrzymanie programu
  }

  // Ustawienie nazwy i dodanie ledService jako usługi rozgłaszającej
  BLE.setLocalName("RemoteLED");
  BLE.setAdvertisedService(ledService);

  // Dodanie deskryptora do charakterystyki usługi
  ledCharacteristic.addDescriptor(ledDescriptor);
  
  // Dodanie charakterystyki do usługi
  ledService.addCharacteristic(ledCharacteristic);
  BLE.addService(ledService); // Dodanie usługi do systemu BLE

  ledCharacteristic.writeValue(0); // Inicjalizacja z 0

  BLE.advertise();
}

void loop() 
{
  BLE.poll();
  
  if (ledCharacteristic.written()) 
  {
    if (ledCharacteristic.value()) 
    {
      digitalWrite(LED_BUILTIN, HIGH);
    } 
    else 
    {
      digitalWrite(LED_BUILTIN, LOW);
    }
  }
}
