/*
 * Tzkic two_i2c
 * Odczytuje wartości z czujnika jakości powietrza i pokazuje stężenie lotnych związków organicznych na wyświetlaczu LED
 */

#include <Adafruit_CCS811.h>
#include <Adafruit_GFX.h>
#include <Adafruit_LEDBackpack.h>

// Tworzenie obiektów dla czujnika i wyświetlacza
Adafruit_CCS811 ccs;
Adafruit_7segment matrix = Adafruit_7segment();

void setup() 
{
  Serial.begin(9600);
  if(!ccs.begin())
  {
    Serial.println("Nie można uruchomić czujnika.");
    while(1); // Zatrzymanie programu
  }
  while(!ccs.available()); // Czekaj, aż czujnik będzie gotowy do działania

  matrix.begin(0x70); // Inicjalizacja matrycy

}

void loop() 
{
  if(ccs.available())
  {
    if(!ccs.readData())
    {
      int tvoc = ccs.getTVOC(); // Odczyt stężenia lotnych związków organicznych
      matrix.println(tvoc);     // Zapis wartości
      matrix.writeDisplay();    // Aktualizacja wyświetlacza
    }
  }
  delay(500);
}
