/*
 * Szkic formattext
 */

#include <LiquidCrystal.h> // Dołączenie biblioteki

//Stałe przechowujące liczbę wierszy i kolumn wyświetlacza LCD
const int numRows = 2;
const int numCols = 16;

int count;

// Inicjalizacja biblioteki z podanymi numerami pinów interfejsu
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

void setup()
{
  lcd.begin(numCols, numRows);
  lcd.print("Startujemy za ");  // Łańcuch złożony z 14 znaków
  for(int i=9; i > 0; i--)    // Odliczanie w dół od 9
  {
    // górny wiersz ma numer 0
    lcd.setCursor(14,0); // ustawienie kursora na końcu łańcucha znaków
    lcd.print(i);
    delay(1000);
  }
}

void loop()
{
  int columnWidth = 4;         //Szerokość kolumn
  int displayColumns = 3;      //Liczba kolumn w danymi

  lcd.clear();
  for( int col=0; col < displayColumns; col++)
  {
    lcd.setCursor(col * columnWidth, 0);
    count = count+ 1;
    lcd.print(count);
  }
  delay(1000);
}
