/*
 * Szkic tone
 *
 * Dźwięki odtwarzane są za pomocą głośnika podłączonego do pinu 9
 * Częstotliwość zależy od wartości odczytanych z analogowego pinu
 */

const int speakerPin = 9;    // Pin głośnika
const int pitchPin = A0;     // Analogowy pin potencjometru, który określa częstotliwość dźwięku

void setup()
{
}

void loop()
{
  int sensor0Reading = analogRead(pitchPin);    // Odczyt wartości wejściowej w celu ustawienia częstotliwości

  // Skalowanie odczytów analogowych
  int frequency  = map(sensor0Reading, 0, 1023, 100, 5000); // od 100 Hz do 5k Hz

  int duration = 250;   // Długość dźwięku
  tone(speakerPin, frequency, duration); // Odtworzenie dźwięku
  delay(1000); // Przerwa 1 s
}
