/*
 * Szkic bargraph_neo
 * Włącza diody LED, których liczba jest proporcjonalna do wartości czujnika analogowego
 */

#include <Adafruit_NeoPixel.h>

const int sensorPin = A0; // Analogowy pin wejścia podłączony do zmiennego rezystora

const int ledsPin = 2;   // Pin, do którego podłączona jest taśma LED
const int numOfLeds = 16; // Liczba diod LED na taśmie

//Stałe do skalowania wartości czujnika
const int minReading = 0;
const int maxReading = 1023;

//Deklaracja taśmy LED
Adafruit_NeoPixel leds = Adafruit_NeoPixel(numOfLeds, ledsPin, NEO_GRB + NEO_KHZ800);

void setup() {
  leds.begin();   //Inicjalizacja taśmy LED
  leds.setBrightness(25);
}

void loop() {
  int sensorReading =  analogRead(A0);
  int nbrLedsToLight = map(sensorReading, minReading, maxReading, 0, numOfLeds);

  for (int i = 0; i < numOfLeds; i++)
  {
    if ( i < nbrLedsToLight)
      leds.setPixelColor(i, leds.Color(0, 0, 255)); // Niebieski
    else
      leds.setPixelColor(i, leds.Color(0, 255, 0)); // Zielony
  }
  leds.show();
}
