/*
 * Szkic SevenSegment
 * Pokazuje liczby od 0 do 9 na jednej cyfrze wyświetlacza
 * Ten szkic odlicza sekundy od 0 do 9
 */

// Bity reprezentujące segmenty od A do G (i kropkę dziesiętną) dla liczb 0-9
const byte numeral[10] = {
 //ABCDEFG + kropka dziesiętna
  B11111100,  // 0
  B01100000,  // 1
  B11011010,  // 2
  B11110010,  // 3
  B01100110,  // 4
  B10110110,  // 5
  B00111110,  // 6
  B11100000,  // 7
  B11111110,  // 8
  B11100110,  // 9
};

// Piny dla kropki dzisiętnej i każdego segmentu
// Kropka dziesiętna,G,F,E,D,C,B,A
const int segmentPins[8] = { 5,8,9,7,6,4,3,2};

void setup()
{
  for(int i=0; i < 8; i++)
  {
    pinMode(segmentPins[i], OUTPUT); // Ustawienie pinów kropki dziesiętnej i segmentów jako wyjścia
  }
}

void loop()
{
  for(int i=0; i <= 10; i++)
  {
    showDigit(i);
    delay(1000);
  }
  // Ostatnią wartością jest 10, która spowoduje wyłączenie wyświetlacza
  delay(2000);  // Wyświetlacz będzie wyłączony przez 2 sekundy
}

// Wyświetlanie cyfr od 0 do 9 na wyświetlaczu 7-segmentowym
// Każda wartość spoza zakresu 0-9 wyłącza wyświetlacz
void showDigit(int number)
{
  bool isBitSet;

  for(int segment = 1; segment < 8; segment++)
  {
    if( number < 0 || number > 9){
      isBitSet = 0;   // Wyłączenie wszystkich segmentów
    }
    else{
      // isBitSet będzie równe true jeśli dany bit jest równy 1
      isBitSet = bitRead(numeral[number], segment);
    }
    isBitSet = ! isBitSet; // Usuń tę linijkę jeśli wyświetlacz ma wspólną katodę
    digitalWrite(segmentPins[segment], isBitSet);
  }
}
