/* Szkic ping
 * Czujnik Ping)))
 * Wyświetla odległość i zmienia częstotliwość migania diody LED,
 * w zależności od odległości obiektu od czujnika Ping)))
 */

const int pingPin = 5;
const int ledPin = LED_BUILTIN; // Pin diody LED

void setup()
{
  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);
}

void loop()
{
  int cm = ping(pingPin);
  Serial.println(cm);

  digitalWrite(ledPin, HIGH);
  delay(cm * 10); // Każdy centymetr dodaje 10 milisekund do opóźnienia
  digitalWrite(ledPin, LOW);
  delay(cm * 10);
}

// Pomiar odległość i zwrócenie wartości w centymetrach
int ping(int pingPin)
{
  long duration; // Zmienna przechowująca długość impulsu

  // Ustawienie pingPin jako wyjścia
  pinMode(pingPin, OUTPUT);
  digitalWrite(pingPin, LOW); // Pozostaje w stanie niskim przez 2μs, aby upewnić się, że impuls jest czysty
  delayMicroseconds(2);

  // Wysłanie impulsu o długości 5μs
  digitalWrite(pingPin, HIGH);
  delayMicroseconds(5);
  digitalWrite(pingPin, LOW);

  // Ustawienie pingPin jako wyjścia i odczyt długości impulsu
  pinMode(pingPin, INPUT);
  duration = pulseIn(pingPin, HIGH);

  // Zamiana czasu na odległość
  return duration / 29 / 2;
}
