// Szkic Processing
              
/* szkic SendingBinaryToArduino
 * Język: Processing
 */
import processing.serial.*;

Serial myPort;  // tworzenie obiektu klasy Serial
public static final char HEADER    = 'H';
public static final char MOUSE_TAG = 'M';

void setup()
{
  size(512, 512);
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}

void draw(){
}

void serialEvent(Serial p) {
  // obsługa przychodzących danych szeregowych
  String inString = myPort.readStringUntil('\n');
  if(inString != null) {     
    print( inString );   // wyświetl tekst z Arduino
  }
}

void mousePressed() {
  sendMessage(MOUSE_TAG, mouseX, mouseY);
}

void sendMessage(char tag, int x, int y){
  // wysłanie podanego indeksu i wartości do portu szeregowego
  myPort.write(HEADER);
  myPort.write(tag);
  myPort.write((char)(x / 256)); // najbardziej znaczący bit
  myPort.write(x & 0xff);  // najmniej znaczący bit
  myPort.write((char)(y / 256)); // najbardziej znaczący bit
  myPort.write(y & 0xff);  // najmniej znaczący bit
}
