// szkic ReadCommaDelimited
// Szkic Processing odczytujący oddzielone przecinkiem dane z portu szeregowego             
// wymagany format: H,1,2,3

import processing.serial.*;

Serial myPort;        // tworzenie obiektu klasy Serial
char HEADER = 'H';    // znak identyfikujący początek wiadomości
short LF = 10;        // koniec linii w ASCII

// UWAGA!
// W razie potrzeby zmień poniższą definicję podając poprawny numer portu.
short portIndex = 0;  // wybór portu szeregowego, 0 oznacza pierwszy port

void setup() {
  size(200, 200);
  println( (Object[]) Serial.list());
  println(" Łączenie z -> " + Serial.list()[portIndex]);
  myPort = new Serial(this, Serial.list()[portIndex], 9600);
}

void draw() {
  if (myPort.available() > 0) {

    String message = myPort.readStringUntil(LF); // odczyt danych szeregowych
    if (message != null)
    {
      message = message.trim(); // usunięcie znaków niedrukowanych z początku i końca łańcucha znaków
      println(message);
      String [] data = message.split(","); // podzielenie wiadomości złożonej z elementów oddzielonych przecinkami
      if (data[0].charAt(0) == HEADER && data.length == 4) // sprawdzenie poprawności formatu otrzymanej wiadomości
      {
        for (int i = 1; i < data.length; i++) // pominięcie nagłówka (start od 1, nie od 0)                       
        {
          println("Wartość " +  i + " = " + data[i]);  // wyświetlenie wartości elementu tablicy
        }
        println();
      }
    }
  }
}
