/*
 * Szkic udp
 * Ten szkic odbiera wiadomości UDP, wyświetla je w terminalu portu szeregowego i wysyła do nadawcy odpowiedź o treści "przyjęte"
 */

#include <SPI.h>         
#include <Ethernet.h>
#include <EthernetUdp.h> 

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // adres MAC

unsigned int localPort = 8888; // Nasłuchiwany port lokalny

// bufory do odbierania i wysyłania danych
char packetBuffer[UDP_TX_PACKET_MAX_SIZE]; // Bufor do zapisywania otrzymanych pakietów
char replyBuffer[] = "przyjęte";       // Odpowiedź

// Instancja UDP umożliwiająca wysyłanie i odbieranie wiadomości przez UDP
EthernetUDP Udp;

void setup() 
{
  Serial.begin(9600);

  // Uruchomienie Ethernetu i UDP
  Ethernet.begin(mac);
  Udp.begin(localPort);
}

void loop() 
{
  // Gdy są dostępne dane, odczytaj pakiet
  int packetSize =  Udp.parsePacket(); 
  if(packetSize)
  {
    Serial.print("Otrzymano pakiet o rozmiarze:  ");
    Serial.println(packetSize);

    // Odczytanie pakietu do packetBuffer oraz uzyskanie adresu IP nadawcy i numeru portu
    Udp.read(packetBuffer,UDP_TX_PACKET_MAX_SIZE);
    Serial.println("Zawartość:");
    Serial.println(packetBuffer);

    // Odesłanie odpowiedzi 
    Udp.beginPacket(Udp.remoteIP(), Udp.remotePort());
    Udp.write(replyBuffer);
    Udp.endPacket();
  }
  maintainLease(); // Utrzymanie połączenia z DHCP
  delay(10);
}

#define MAINTAIN_DELAY 750 // Utrzymanie dzierżawy DHCP co 0,75 s
void maintainLease()
{
  static unsigned long nextMaintain = millis() + MAINTAIN_DELAY;
  if (millis() > nextMaintain)
  {
    nextMaintain = millis() + MAINTAIN_DELAY;
    int ret = Ethernet.maintain();
    if (ret == 1 || ret == 3)
    {
      Serial.print("Nie udało się utrzymać dzierżawy DHCP. Błąd: ");
      Serial.println(ret);
    }
    Serial.print("Obecny adres IP: ");
    IPAddress myIPAddress = Ethernet.localIP(); 
    Serial.println(myIPAddress);  
  }
}
