/*
 * Szkic extract_data
 * Szkic, który może działać z płytkami ESP8266, z Wi-Fi, i z Ethernetem
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

#include <TimeLib.h>

char server[] = "api.open-notify.org";
void setup()
{
  Serial.begin(9600);
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1) 
    {
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
    }
  }

  int ret = client.connect(server, 80); 
  if (ret == 1) 
  {
    Serial.println("Połączono");
    client.println("GET /iss-now.json HTTP/1.0"); // Żądanie HTTP
    client.print("Host: "); client.println(server);
    client.println("Połączenie: zamknięte");
    client.println();
  } 
  else 
  {
    Serial.println("Połączenie nieudane, z powodu błędu: ");
    Serial.print(ret, DEC);
    while(1)
    {
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
    }
  }
}

char timestampMarker[] = "\"timestamp\":";
char posMarker[] = "\"iss_position\":";
void loop()
{
  if (client.available()) {
    if (client.find('"')) // Identyfikator początku łańcucha znaków
    {
      String id = client.readStringUntil('"');
      if (id.equals("timestamp")) // Początek znacznika czasowego
      {
        if (client.find(':')) // Dwukropek (":") występuje po każdym identyfikatorze
        {
          unsigned long timestamp = client.parseInt();
          setTime(timestamp); // Ustawienie zegara na czas otrzymania odpowiedzi
          digitalClockDisplay();          
        }
        else
        {
          Serial.println("Nie udało się uzyskać znacznika czasu.");
        }
      }

      if (id.equals("iss_position")) // Początek danych pozycji
      {
        if (client.find(':')) // Dwukropek (":") występuje po każdym identyfikatorze
        {
          // Etykiety zaczynają się cudzysłowem ("), a łańcuch znaków zawierający pozycję kończy się nawiasem klamrowym "}"
          while (client.peek() != '}' && client.find('"')) 
          {
            String id = client.readStringUntil('"'); // Odczytanie etykiety
            float val = client.parseFloat(); // Odczytanie wartości
            client.find('"'); // Usunięcie cudzysłowu (") po wartości zmiennoprzecinkowej
            Serial.print(id + ": "); Serial.println(val, 4); 
          }      
        }
        else
        {
          Serial.println("Nie udało się uzyskać pozycji.");
        }
      }
    }
  }

  if (!client.connected()) 
  {
    Serial.println();
    Serial.println("Rozłączanie...");
    client.stop();
    while(1)
    {
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
    }
  }
}

String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera na początku cyfry
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich 
}

void digitalClockDisplay()
{
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(datestr + " " + timestr);
}
