/*
 * Szkic xbee_message
 * Wysyła wiadomość do XBee używając jego adresu
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
//#define MYSERIAL Serial // Uno, Nano i inne płytki AVR
#define MYSERIAL Serial1 // Nano Every, Uno WiFi R2, Leonardo oraz płytki ARM

bool configured;

bool configureRadio() 
{
  // Ustawienie trybu poleceń na radiu:
  MYSERIAL.flush();
  MYSERIAL.print("+++");
  delay(100);

  String ok_response = "OK\r"; // Oczekiwana odpowiedź

  // Zapisanie treści odpowiedzi do zmiennej response
  String response = String("");
  while (response.length() < ok_response.length()) 
  {
    if (MYSERIAL.available() > 0) 
    {
      response += (char) MYSERIAL.read();
    }
  }

  // Jeśli została otrzymam prawidłowa odpowiedź, skonfiguruj moduł radiowy i zwróć true
  if (response.equals(ok_response)) 
  {
    MYSERIAL.print("ATDH0013A200\r"); // Adres wysoki, zastąp 0013A200
    delay(100);
    MYSERIAL.print("ATDL403B9E1E\r"); // Adres niski, zastąp 403B9E1E
    delay(100);
    MYSERIAL.print("ATCN\r");     // Powrót do trybu danych
    return true;
  } 
  else 
  {
    return false; // To oznacza, że otrzymana odpowiedź była niepoprawna
  }
}

void setup () 
{
  MYSERIAL.begin(9600); // Inicjalizacja połączenia szeregowego
  delay(1000);
  configured = configureRadio();
}

void loop () 
{
  if (configured) 
  {
    MYSERIAL.print("Witaj!");
    delay(3000);
  }
  else 
  {
    delay(30000);     // Czekaj 30 s
    configured = configureRadio(); // Spróbuj ponownie
  }
}
