/*
 * Szkic two_spi
 * Wgrywa wszystkie bitmapy z podłączonej karty SD, a następnie wyświetla je na ekranie TFT
 */

#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>
#include <SdFat.h>
#include <Adafruit_ImageReader.h>

#define SD_CS   4 // Linia wybierająca dla czytnika kart SD
#define TFT_CS 10 // Linia wybierająca dla TFT
#define TFT_DC  9 // Pin danych/poleceń dla TFT
#define TFT_RST 8 // Pin resetu dla TFT

// Tworzenie obiektu dla każdego z urządzeń SPI
SdFat SD;
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);

SdFile root; // Folder główny karty SD
Adafruit_ImageReader reader(SD); // Obiekt wgrywający i wyświetlający bitmapy

void setup(void) 
{
  Serial.begin(9600);
  if(!SD.begin(SD_CS, SD_SCK_MHZ(25))) // Inicjalizacja czytnika kart SD na częstotliwości 25 MHz
  { 
    Serial.println("Błąd inicjalizacji karty SD");
    while(1); // Zatrzymanie programu
  }
  tft.begin(); // Inicjalizacja TFT

  if (!root.open("/")) 
  {
    Serial.println("Nie można odczytać folderu karty SD");
    while(1); // Zatrzymanie programu
  }
}

void loop() 
{
  ImageReturnCode rc; // Wyjście z kodu operacji na obrazach
  SdFile file; // Bieżący plik
  char filename[256]; // Bufor z nazwą pliku

  while (file.openNext(&root, O_RDONLY)) // Szukanie kolejnego pliku na karcie SD 
  {
    file.getName(filename, sizeof(filename)/ sizeof(filename[0]));
    if(isBMP(filename)) // Jeśli jest to plik w formacie BMP, wyświetl go na ekranie TFT
    {
      tft.fillScreen(0);
      rc = reader.drawBMP(filename, tft, 0, 0);
      delay(2000); // Przerwa
    }
    file.close();
  }
  root.rewind(); // Powrót do pierwszego pliku w katalogu głównym
}

// Określenie czy plik jest bitmapą (BMP)
int isBMP(char fname[])
{
  String fn = String(fname);
  fn.toLowerCase();
  return fn.endsWith("bmp");
}
