/*
 * szkic marquee_long
 * Szkic przewijający bardzo długi tekst 
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);
const int numRows = 2;
const int numCols = 16;

void setup()
{
  // inicjalizacja ekranu LCD z podaną liczbą kolumn i wierszy
  lcd.begin(numCols, numRows);
  marquee("To jest bardzo długi tekst, który zostanie przewinięty
}

void loop()
{
}

// Ta wersja funkcji marquee wykorzystuje ręczne przewijane bardzo długich wiadomości.
void marquee(char *text)
{
  int length = strlen(text); // liczba znaków w tekście
  if(length < numCols)
    lcd.print(text);
  else
  {
    int pos;
    for(pos = 0; pos < numCols; pos++)
       lcd.print(text[pos]);
    delay(1000); // czas potrzebny na odczytanie pierwszej linjki przed przewinięciem
    pos=1;
    while(pos <= length - numCols)
    {
      lcd.setCursor(0,0);
      for(int i=0; i < numCols; i++)
        lcd.print(text[pos+i]);
      delay(300);
      pos = pos + 1;
    }
  }
}
