/*
 * Szkic liquidcrystal
 * Biblioteka LiquidCrystal Library - Hello World
 *
 * Pokazuje wykorzystanie wyświetlacza LCD 16 × 2.
 * https://www.arduino.cc/en/Tutorial/HelloWorld
 */

#include <LiquidCrystal.h> // Dołączenie biblioteki

//Stałe przechowujące  liczbę wierszy i kolumn wyświetlacza LCD
const int numRows = 2;
const int numCols = 16;

// Inicjalizacja biblioteki z podanymi numerami pinów interfejsu
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

void setup()
{
  lcd.begin(numCols, numRows);
  lcd.print("Hello, World!");  // Wyświetlenie wiadomości na ekranie LCD
}

void loop()
{
  // Ustawienie kursora w wierszu 1, kolumnie 0
  // (numeracja wierszy zaczyna się od 0, więc linia 1 to drugi wiersz):
  lcd.setCursor(0, 1);
  // Wyświetlenie czasu jaki upłynął od momentu rozpoczęcia działania szkicu
  lcd.print(millis()/1000);
}
