/*
 * Szkic customchar_pixel
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

//Stałe przechowujące liczbę wierszy i kolumn wyświetlacza LCD
const int numRows = 2;
const int numCols = 16;

// Tablica bitów definiujących stan pikseli dla ośmiu znaków specjalnych
// Jedynki to piksel włączony, zera - wyłączony

byte glyphs[8][8]  = {
      {B00000,B00000,B00000,B00000,B00000,B00000,B00000,B11111},   // 0
      {B00000,B00000,B00000,B00000,B00000,B00000,B11111,B11111},   // 1
      {B00000,B00000,B00000,B00000,B00000,B11111,B11111,B11111},   // 2
      {B00000,B00000,B00000,B00000,B11111,B11111,B11111,B11111},   // 3
      {B00000,B00000,B00000,B11111,B11111,B11111,B11111,B11111},   // 4
      {B00000,B00000,B11111,B11111,B11111,B11111,B11111,B11111},   // 5
      {B00000,B11111,B11111,B11111,B11111,B11111,B11111,B11111},   // 6
      {B11111,B11111,B11111,B11111,B11111,B11111,B11111,B11111}};  // 7

void setup ()
{
  lcd.begin(numCols, numRows);
  for(int i=0; i < 8; i++)
    lcd.createChar(i, glyphs[i]);     // Tworzenie znaków specjalnych
  lcd.clear();
}

void loop ()
{
  for( byte i=0; i < 8; i++)
    lcd.write(i);   // Pokazanie kolejnych wysokości słupków wykresu
  delay(2000);
  lcd.clear();
}
