/*
 * Szkic optoremote
 * Przełączniki podłączone do pinów 2 i 3 włączają i wyłączają urządzenie wykorzystując transoptory
 * Wyjścia są w stanie wysokim przez przynajmniej pół sekundy, gdy przycisk został wciśnięty
 */

const int onSwitchPin  = 2;         // Pin wejścia dla przełącznika włączającego
const int offSwitchPin = 3;         // Pin wejścia dla przełącznika wyłączającego
const int remoteOnPin  = 4;         // Pin wyjścia służący do włączenia pilota
const int remoteOffPin = 5;         // Pin wyjścia służący do wyłączenia pilota
const int PUSHED       = LOW;       // Zmienna przechowująca wartość, gdy przycisk został wciśnięty

void setup() {
  pinMode(remoteOnPin, OUTPUT);
  pinMode(remoteOffPin, OUTPUT);
  pinMode(onSwitchPin, INPUT_PULLUP);  // Włączneie wbudowanych rezystorów podciągających na pinach wejścia
  pinMode(offSwitchPin, INPUT_PULLUP);
}

void loop(){
  int val = digitalRead(onSwitchPin);  // Odczyt wartości wejścia
  // Gdy przycisk został naciśnięty, włącz przycisk, jeśli nie jest jeszcze włączony
  if(val == PUSHED)
  {
    pulseRemote(remoteOnPin);
  }

  val = digitalRead(offSwitchPin);  // Odczyt wartości wejścia
  // Gdy przycisk został naciśnięty, wyłącz przycisk, jeśli nie jest jeszcze wyłączony
  if(val == PUSHED)
  {
    pulseRemote(remoteOffPin);
  }
}

// Włącz transoptory na pół sekundy, aby zmienić stan przycisku pilota
void pulseRemote(int pin)
{
  digitalWrite(pin, HIGH);     // Włączenie transoptora
  delay(500);                  // Przerwa 0,5 s
  digitalWrite(pin, LOW);      // Wyłączenie transoptora
}
