/*
 * Szkic ir_send
 * Ten szkic wymaga podczerwonej diody LED, podłączonej do pinu 3
 * oraz 5 przycisków podłączonych do pinów od 6 do 10
 */

#include <IRremote.h>       // Biblioteka zdalnego sterowania na podczerwień

const int numberOfKeys = 5;
const int firstKey = 6;   // Pin pierwszego przycisku z pięciu podłączonych do sąsiadujących ze sobą pinów 
                        
bool buttonState[numberOfKeys];
bool lastButtonState[numberOfKeys];
long irKeyCodes[numberOfKeys] = {
  0x18E758A7,  //Przycisk 0 
  0x18E708F7,  //Przycisk 1
  0x18E78877,  //Przycisk 2
  0x18E748B7,  //Przycisk 3
  0x18E7C837,  //Przycisk 4
};

IRsend irsend;

void setup()
{
  for (int i = 0; i < numberOfKeys; i++) {
    buttonState[i] = true;
    lastButtonState[i] = true;
    int physicalPin=i + firstKey;
    pinMode(physicalPin, INPUT_PULLUP);  // Włączenie rezystorów podciągających
  }
  Serial.begin(9600);
}

void loop() {
  for (int keyNumber=0; keyNumber<numberOfKeys; keyNumber++)
  {
    int physicalPinToRead = keyNumber + firstKey;
    buttonState[keyNumber] = digitalRead(physicalPinToRead);
    if (buttonState[keyNumber] != lastButtonState[keyNumber])
    {
      if (buttonState[keyNumber] == LOW)
      {
        irsend.sendSony(irKeyCodes[keyNumber], 32);
        Serial.println("Wysyłanie");
      }
      lastButtonState[keyNumber] = buttonState[keyNumber];
    }
  }
}
