/*
 * Szkic tone_fade
 * Odtwarza dźwięki i ściemnia diodę LED
 */
byte speakerPin = 9;
byte ledPin = 3;

void setup()
{
  pinMode(speakerPin, OUTPUT);
}

void playTone(int period, int duration)
{
  // Okres to jeden cykl nuty
  // Długość impulsu w ms
  int pulse = period / 2;
  for (long i = 0; i < duration * 1000L; i += period )
  {
    digitalWrite(speakerPin, HIGH);
    delayMicroseconds(pulse);
    digitalWrite(speakerPin, LOW);
    delayMicroseconds(pulse);
  }
}

void fadeLED(){
  // Te dwie statyczne zmienne mają przypisywane wartości tylko przy pierwszym wywołaniu funkcji
  static int brightness = 0;
  static int changeval  = 5;

  analogWrite(ledPin, brightness);

  // Jeśli zostanie przekroczony limit analogWrite,
  brightness += changeval;
  if (brightness >= 255 || brightness <= 0)
    changeval *= -1; // zmień kierunek

  delay(2);
}

void loop()
{
  // Nuta o okresie równym 15289 to niskie C (druga najniższa nuta C na pianinie)
  for(int period=15289; period >= 477;  period=period / 2)  // Zagraj pięć oktaw
  {
    playTone(period, 200); // Zagraj dźwięk przez 200 ms
    fadeLED();
  }
}
