/*
 * Szkic midi
 * Wysyła wiadomości MIDI w celu odegrania skali na instrumencie MIDI po każdym naciśnięciu przycisku
*/

// Poniższe liczby  reprezentują nuty do zagrania
const byte notes[8] = {60, 62, 64, 65, 67, 69, 71, 72}; 
const int num_notes = sizeof(notes)/ sizeof(notes[0]);;

const int switchPin = 2;
const int ledPin = LED_BUILTIN;

void setup() {
  Serial.begin(31250);
  pinMode(switchPin, INPUT_PULLUP);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  if (digitalRead(switchPin) == LOW)
  {
    for (byte noteNumber = 0; noteNumber < num_notes; noteNumber++)
    {
      // Zagraj nutę
      playMidiNote(1, notes[noteNumber], 127);
      digitalWrite(ledPin, HIGH);
      delay(70); // Graj nutę przez 70 s
      
      // Przerwij granie nuty (prędkość równa 0)
      playMidiNote(1, notes[noteNumber], 0);
      digitalWrite(ledPin, HIGH);
      delay(30);
    }
  }
}

void playMidiNote(byte channel, byte note, byte velocity)
{
  byte midiMessage= 0x90 + (channel - 1);
  Serial.write(midiMessage);
  Serial.write(note);
  Serial.write(velocity);
}
