#include <FrequencyTimer2.h>  // biblioteka potrzebna do obsługi odświeżania wyświetlacza

byte pins[] = {2,3,4};
const int NUMBER_OF_PINS = sizeof(pins)/ sizeof(pins[0]);
const int NUMBER_OF_LEDS = NUMBER_OF_PINS * (NUMBER_OF_PINS-1);

byte pairs[NUMBER_OF_LEDS/2][2] = { {2,1}, {1,0}, {2,0} }; 

int ledStates = 0; //zmienna przechowująca stan maksymalnie 15 diod LED
int refreshedLed;  // odświeżana dioda LED

void setup()
{
  FrequencyTimer2::setPeriod(20000/NUMBER_OF_LEDS); // ustawienie częstotliwości
  // następna linijka informuje FrequencyTimer2 jaka funkcja ma być wywołana (ledRefresh)
  FrequencyTimer2::setOnOverflow(ledRefresh);
  FrequencyTimer2::enable();
}

void loop()
{
const int analogInPin = 0; // analogowy pin wejścia podłączony do opornika zmiennego

  // kod ze szkicu bargraph
  int sensorValue = analogRead(analogInPin);          // odczyt wejściowej wartości analogowej
  // skalowanie odczytu do liczby diod LED
  int ledLevel = map(sensorValue, 0, 1023, 0, NUMBER_OF_LEDS);    
  for (int led = 0; led < NUMBER_OF_LEDS; led++)
  {
    if (led < ledLevel ) {
      setState(led, HIGH);     // włączenie pinów poniżej poziomu
    }
    else {
      setState(led, LOW);      // wyłączenie pinów powyżej poziomu
    }
  }
   // Dioda LED nie jest już odświeżana w funkcji loop. Jest o obsługiwane przez FrequencyTimer2.
}

void setState( int led, bool state)
{
   bitWrite(ledStates,led, state);
}

void ledRefresh()
{
   // rzy każdym wywołaniu funkcji, odśwież inną diodę LED.
   if( refreshedLed++ > NUMBER_OF_LEDS) // przejście do kolejnej diody LED
      refreshedLed = 0; // Jeśli wszystkie zostały odświeżone, zacznij od początku.

   if( bitRead(ledStates, refreshedLed ) == HIGH)
         lightLed( refreshedLed );
   else 
       if(refreshedLed == 0) // Wyłącz wszystkie diody, jeśli pin 0 jest wyłączony.
         for(int i=0; i < NUMBER_OF_PINS; i++)
           digitalWrite(pins[i],LOW);
}

// Ta funkcja jest dokładnie taka sama, jak ta w szkicu pokazanym w Rozwiązaniu.
// funkcja zapalająca podaną diodę LED, pierwsza ma numer 0
void lightLed(int led)
{
  // Poniższe cztery linijki zamieniają numer diody LED na numer pinu.
  int indexA = pairs[led/2][0];
  int indexB = pairs[led/2][1];
  int pinA = pins[indexA];
  int pinB = pins[indexB];

  // wyłączenie wszystkich pinów niepodłączonych do podanej diody LED
  for(int i=0; i < NUMBER_OF_PINS; i++)
  {
    if(pins[i] != pinA && pins[i] != pinB)
    {  // Jeśli ten pin nie jest żadnym z naszych pinów,
        pinMode(pins[i], INPUT);   // ustaw tryb na wejście,
        digitalWrite(pins[i],LOW); // upewnij się, że rezystory podciągające są wyłączone.
    }
  }
  // Teraz włącz piny dla podanej diody LED.
  pinMode(pinA, OUTPUT);
  pinMode(pinB, OUTPUT);
  if( led % 2 == 0)
  {
     digitalWrite(pinA,LOW);
     digitalWrite(pinB,HIGH);
  }
  else
  {
     digitalWrite(pinB,LOW);
     digitalWrite(pinA,HIGH);
  }
}
