/*
* Szkic analog_meter
* Za pomocą pinu PWM steruje analogowym miernikiem
* Poziom miernika jest kontrolowany przez rezystor nastawny podłączony do analogowego pinu wejścia
*/

const int analogInPin = A0; // Rezystor nastawny podłączony do analogowego wejścia
const int analogMeterPin = 9; // Miernik podłączony do analogowego wyjścia

int sensorValue = 0; // Wartość odczytana z potencjometru
int outputValue = 0; // Wartość wyjściowa dla PWM (wyjście analogowe)

void setup()
{
// Nie są wymagane żadne ustawienia
}

void loop()
{
  sensorValue = analogRead(analogInPin); // Odczyt analogowej wartości wejściowej
  outputValue = map(sensorValue, 0, 1023, 0, 255); // Skalowanie dla analogowego wyjścia
  analogWrite(analogMeterPin, outputValue); // Zapisanie na pinie miernika analogowej wartości wyjściowej
}
