/*
  Szkic HT16K33
*/

#include <Wire.h>
#include <Adafruit_GFX.h>
#include "Adafruit_LEDBackpack.h"

Adafruit_7segment matrix = Adafruit_7segment();

const int numberOfDigits = 4; // Zmień tę wartość, aby pasowała do liczby podłączonych cyfr
const int maxCount       = 9999;

int number = 0;

void setup()
{
  Serial.begin(9600);
  matrix.begin(0x70);     // Inicjalizacja wyświetlacza
  matrix.println(number); // Wysłanie liczy do wyświetlacza (na początku 0)
  matrix.writeDisplay();  // Aktualizacja wyświetlacza
}

void loop()
{
  // Wyświetlenie liczby otrzymanej z portu szeregowego, zakończonej znakiem końca linii
  if (Serial.available())
  {
    char ch  = Serial.read();
    if ( ch == '\n')
    {
      if (number <= maxCount)
      {
        matrix.println(number);
        matrix.writeDisplay();
        number = 0; // Wyzerowanie liczby
      }
    }
    else
      number = (number * 10) + ch - '0'; // Szczegóły znajdziesz w Rozdziale 4
  }
}
