/*
 * szkic debounce_pullup
 * Podłączony do pinu przełącznik zapala wbudowaną diodę LED.
 * Logika rozwiązująca problem drgających styków eliminuje błędne odczyty.
 */

const int inputPin = 2;        // numer pinu wejścia
const int debounceDelay = 10;  // liczba iteracji, która musi być wykonana, aby ustabilizować pin
bool last_button_state = LOW;  // ostatni stan przycisku
int ledState = LOW;            // włączone lub wyłączone (HIGH lub LOW)
int count;   // zmienna przechowująca ilość przyciśnięć

// funkcja debounce zwraca stan, gdy styki są stabilne
bool debounce(int pin)
{
  bool state;
  bool previousState;

  previousState = digitalRead(pin);          // zapisanie stanu przycisku
  for(int counter=0; counter < debounceDelay; counter++)
  {
      delay(1);                  // 1 milisekundowa pauza
      state = digitalRead(pin);  // odczyt pinu
      if( state != previousState)
      {
         counter = 0; // zerowanie licznika (counter) jeśli stan się zmienia
         previousState = state;  // zapisanie aktualnego stanu
      }
  }
  // Zwróć wartość jeśli wartość jest taka sama przy każdym obiegu pętli
  if(state == LOW)  // LOW oznacza, że przycisk został wciśnięty (gdyż użyto rezystorów podciągających)
     return true;
  else
    return false;
}

void setup()
{
  pinMode(inputPin, INPUT_PULLUP);
  pinMode(LED_BUILTIN, OUTPUT);
  Serial.begin(9600); // dodana inicjalizacja  portu szeregowego
}

void loop()
{
  bool button_state = debounce(inputPin);
    if (button_state)
  {
      count++; // increment count
      Serial.println(count);  // wyświetl zmienną count w monitorze portu szeregowego
  }

  // Jeśli stan przycisku się zmienił i przycisk został naciśnięty,
  if (last_button_state != button_state && button_state == HIGH) {
    // zmień stan diody LED
    ledState = !ledState;
    digitalWrite(LED_BUILTIN, ledState);
  }
  last_button_state = button_state;
}
