/*
  Szkic array
  Tablica przełączników kontrolująca tablicę diod LED
  Zobacz rozdział 5., „Proste wejścia cyfrowe i analogowe”, aby dowiedzieć się więcej na temat użycia przełączników.
  Zobacz rozdział 7., „Optyczne urządzenia wyjścia”, aby dowiedzieć się więcej na temat diod LED
*/

int inputPins[] = {2, 3, 4, 5};    // Definicja tablicy z pinami dla przycisków
int ledPins[] = {10, 11, 12, 13};  // Definicja tablicy z pinami dla diod LED

void setup()
{
  for (int index = 0; index < 4; index++)
  {
    Serial.println(empty[index]);
    pinMode(ledPins[index], OUTPUT);         // Ustawienie pinu diody LED jako wyjścia
    pinMode(inputPins[index], INPUT_PULLUP); // Ustawienie pinu przycisku jako wejścia
  }
}

void loop() {
  for (int index = 0; index < 4; index++)
  {
    int val = digitalRead(inputPins[index]);  // Odczytaj wartość wejściową
    if (val == LOW)                           // Sprawdź, czy przycisk jest naciśnięty
    {
      digitalWrite(ledPins[index], HIGH); // Zapal diodę LED, jeśli przycisk jest naciśnięty
    }
    else
    {
      digitalWrite(ledPins[index], LOW);  // Wyłącz diodę LED
    }
  }
}
