/*
* ReceiveMultipleFieldsBinaryToFile_P
*
* portIndex musi być równy numerowi portu podłączonego do Arduino
* Szkic bazuje na ReceiveMultipleFieldsBinary. Ta wersja zapisuje dane do pliku.
* Naciśnij dowolny przycisk, aby zakończyć zapisywanie do pliku.
*/
import processing.serial.*;
import java.util.*;
import java.text.*;
PrintWriter output;
DateFormat fnameFormat = new SimpleDateFormat("yyMMdd_HHmm");
DateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
String fileName;
Serial myPort; // tworzenie obiektu klasy Serial
short portIndex = 0; // wybór portu szeregowego, 0 oznacza pierwszy port
char HEADER = 'H';

void setup()
{
  size(200, 200);
  // Otwórz port, do którego podłączone jest Arduino.
  String portName = Serial.list()[portIndex];
  println((Object[]) Serial.list());
  println(" Łączenie z -> " + portName);
  myPort = new Serial(this, portName, 9600);
  Date now = new Date();
  fileName = fnameFormat.format(now);
  output = createWriter(fileName + ".txt"); // Zapisz plik w tym samym folderze co szkic.
}
void draw()
{
  int val;
  if ( myPort.available() >= 15) // Poczekaj, aż zostanie otrzymana cała wiadomość.
  {
    if( myPort.read() == HEADER) // Czy to jest nagłówek?
    {
      String timeString = timeFormat.format(new Date());
      println("Wiadomość otrzymana o " + timeString);
      output.println(timeString);
      // Odbierz liczbę całkowitą zawierająca wartości bitów.
      val = readArduinoInt();
      // wyświetlanie wartości każdego bitu
      for (int pin=2, bit=1; pin <= 13; pin++){
        print("pin cyfrowy " + pin + " = " );
        output.print("pin cyfrowy " + pin + " = " );
        int isSet = (val & bit);
        if (isSet == 0){
          println("0");
          output.println("0");
        }
        else
        {
          println("1");
          output.println("1");
        }
        bit = bit * 2; // przesuń bit
      }
      // wyświetlanie sześciu analogowych wartości
      for (int i=0; i < 6; i ++){
        val = readArduinoInt();
        println("pin analogowy " + i + "=" + val);
        output.println("pin analogowy " + i + "=" + val);
      }
      println("----");
      output.println("----");
    }
  }
}
void keyPressed() {
  output.flush(); // Zapisz pozostałe dane w pliku.
  output.close(); // Zamyknij plik.
  exit(); // Zakończ program.
}
// Zwróć liczbę całkowitą złożoną z otrzymanych bajtow (najpierw dolny bajt, potem górny).
int readArduinoInt()
{
  int val; // dane odebrane z portu szeregowego
  val = myPort.read(); // odczytaj najmniej znaczący bajt
  val = myPort.read() * 256 + val; // dodaj najbardziej znaczący bajt
  return val;
}
