/*
 * Szkic wireless_transmit
 * Wysyła wiadomość do innego modułu i czeka na odpowiedź
 */
#include <SPI.h>
#include <RH_RF69.h>
#include <RHReliableDatagram.h>

#define MY_ADDR   2 // Adres tego węzła
#define DEST_ADDR 1 // Adres drugiego węzła

#define RF69_FREQ 915.0 // Ustawienie obsługiwanej częstotliwości

// Defnicja sterownika radia
#define RFM69_INT  3 
#define RFM69_CS   4
#define RFM69_RST  2
RH_RF69 rf69(RFM69_CS, RFM69_INT);

// Obiekt zarządzający dostarczaniem wiadomości
RHReliableDatagram rf69_manager(rf69, MY_ADDR);

void setup() 
{
  Serial.begin(9600);

  pinMode(LED_BUILTIN, OUTPUT);    
  pinMode(RFM69_RST, OUTPUT);
  digitalWrite(RFM69_RST, LOW);

  Serial.println("Ponowne uruchamianie radia");
  digitalWrite(RFM69_RST, HIGH); delay(10);
  digitalWrite(RFM69_RST, LOW); delay(10);
  
  if (!rf69_manager.init()) 
  {
    Serial.println("Nie można uruchomić radia");
    while (1); // zatrzymanie programu
  }

  if (!rf69.setFrequency(RF69_FREQ)) {
    Serial.println("Nie można ustawić częstotliwości");
    while (1); // Zatrzymanie programu
  }

  // Jeśli używasz wersji  modułu RF69 (RFM69HW/HCW) o dużej mocy,
  // wymagany jest poniższy kod
  rf69.setTxPower(20, true);  // Zakres zasilania to: 14-20
  
  // Każdy węzeł musi używać tego samego klucza.
  uint8_t key[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  rf69.setEncryptionKey(key);
  
  Serial.print("Radio RFM69 działa na częstotliwości: ");
  Serial.print((int)RF69_FREQ); Serial.println(" MHz");
}

byte response[RH_RF69_MAX_MESSAGE_LEN]; // Bufor przechowujący wiadomości z drugiego urządzenia
byte message[] = "Witaj!";
void loop() 
{
  delay(1000); // Czekaj 1 s

  if (rf69_manager.sendtoWait((byte *)message, strlen(message), DEST_ADDR))
  {
    byte len = sizeof(response);
    byte sender; // ID nadawcy

    // Czekaj na odpowiedź
    if (rf69_manager.recvfromAckTimeout(response, &len, 2000, &sender)) 
    {
      response[len] = 0; // Dodanie nul (0) na końcu odpowiedzi

      Serial.print("Odebrano ["); Serial.print((char *) response);
      Serial.print("] od "); Serial.println(sender);

      // mignięcie diody LED
      digitalWrite(LED_BUILTIN, HIGH); delay(250);
      digitalWrite(LED_BUILTIN, LOW); delay(250);
    } 
    else 
    {
      Serial.print("Nie otrzymano odpowiedzi od "); Serial.println(sender);
    }
  } 
  else 
  {
    Serial.print("Błąd wysyłania wiadomości do "); Serial.println(DEST_ADDR);
  }
}
