/*
 * Szkic scroll
 * Jeśli wyświetlacz zostanie przechylony, tekst będzie przewijany w lewo,
 * w przeciwnym razie, w prawo
 */

#include <LiquidCrystal.h>

// Inicjalizacja biblioteki z podanymi numerami pinów interfejsu
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);
const int numRows = 2;
const int numCols = 16;

const int tiltPin = 7; // Piny podłączone do czujnika przechyłu

const char textString[] = "Przechyl, aby przewinąć tekst w lewo";
const int textLen = sizeof(textString) - 1; // Liczba znaków
bool isTilted = false;

void setup()
{
  // Inicjalizacja ekranu LCD z podaną liczbą kolumn i wierszy
  lcd.begin(numCols, numRows);
  pinMode(tiltPin, INPUT_PULLUP);
  lcd.print(textString);
}

void loop()
{
  if(digitalRead(tiltPin) == LOW && isTilted == false)
  {
    // Wyświetlacz przechylony - przewijanie tekstu w lewo
    isTilted = true;
    for (int position = 0; position  < textLen; position++)
    {
      lcd.scrollDisplayLeft();
      delay(150);
    }
  }
  if(digitalRead(tiltPin) == HIGH && isTilted == true)
  {
    // Poprzednio przechylony, ale teraz ustawiony na płasko - przewijanie tekstu w prawo
    isTilted = false;
    for (int position = 0; position  < textLen; position++)
    {
      lcd.scrollDisplayRight();
      delay(150);
    }
  }
}
