/*
 * Szkic brushed_hbridge
 * Sterowanie kierunkiem obrotu silnika za pomocą poleceń odbieranych z portu szeregowego
 * + lub - ustawienie kierunku, inne znaki - zatrzymanie silnika
 */

const int in1Pin = 5;  // Piny wejścia mostka H
const int in2Pin = 4;

void setup()
{
  Serial.begin(9600);
  pinMode(in1Pin, OUTPUT);
  pinMode(in2Pin, OUTPUT);
  Serial.println("+ - to ustawienie kierunku, inne znaki to zatrzymanie silnika");
}

void loop()
{
  if ( Serial.available()) {
    char ch = Serial.read();
    if (ch == '+')
    {
      Serial.println("zgodnie z kierunkiem wskazówek zegara");
      digitalWrite(in1Pin,LOW);
      digitalWrite(in2Pin,HIGH);
    }
    else if (ch == '-')
    {
      Serial.println("przeciwnie do kierunku wskazówek zegara");
      digitalWrite(in1Pin,HIGH);
      digitalWrite(in2Pin,LOW);
    }
    else if (ch != '\n' && ch != '\r') // Pominięcie znaku nowej linii lub powrotu karetki
    {
      Serial.print("zatrzymanie silnika");
      digitalWrite(in1Pin,LOW);
      digitalWrite(in2Pin,LOW);
    }
  }
}
