/* szkic PN532ReadWrite
 * Zapis na etykietę NFC
 * Odczytuje etykietę NFC i wyświetla jej unikalny numer identyfikacyjny.
 */

/* 
 * Jeśli używasz modułu w przez SPI lub I2C, zobacz przykładowe szkice PN532_SPI lub PN532_I2C.
 */
#include <NfcAdapter.h>
#include <PN532/PN532/PN532.h>
#include <PN532/PN532_HSU/PN532_HSU.h>

PN532_HSU pn532hsu(Serial1);
NfcAdapter nfc(pn532hsu);

void setup() 
{
  Serial.begin(9600);
  nfc.begin(); // inicjalizacja czytnika NFC
}

void loop()
{
  Serial.println("Czekanie na zbliżenie etykiety do czytnika");
  if (nfc.tagPresent()) // Jeśli czytnik widzi etykietę NFC,
  {
    NfcTag tag = nfc.read(); // odczytuje ją
    tag.print(); // i wyświetla wszystkie zapisane na niej informacje.

    // Daj użytkownikowi czas, aby uniknąć przypadkowego zapisu na etykiecie.
    Serial.print("Odliczanie do zapisu URL na etykiecie: 3");
    for (int i = 2; i >= 0; i--) {
      delay(1000);
      Serial.print("..."); Serial.print(i);
    }
    Serial.println();
    
    // zapisanie wiadomości na etykiecie
    NdefMessage message = NdefMessage();
    message.addUriRecord("http://oreilly.com");
    bool success = nfc.write(message);
    if (!success)
      Serial.println("Błąd zapisu.");
    else
      Serial.println("Sukces.");
  }
  delay(500);
}
