/* Szkic DS18B20
 * Odczytuje temperaturę z wodoodpornego czujnika temperatury
 */
#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 2  // Pin, do którego podłączony jest przewód czujnika

const int ledPin = LED_BUILTIN;
const int threshold = 80; // Po przekroczeniu 80F, zapal diodę LED

OneWire oneWire(ONE_WIRE_BUS);       // Przygotuj połączenie OneWire
DallasTemperature sensors(&oneWire); // Deklaracja obiektu czujnika

void setup(void)
{
  Serial.begin(9600);

  // Inicjalizacja czujnika
  sensors.begin();
}

void loop(void)
{ 

  sensors.requestTemperatures(); // Odczyt temperatury

  // pobranie temperatury w F i C
  float fahrenheit = sensors.getTempFByIndex(0);
  float celsius    = sensors.getTempCByIndex(0);

  // Wyświetlenie odczytów temperatury w Kreślarce
  Serial.print("C:"); Serial.print(celsius);
  Serial.print(",");
  Serial.print("F:"); Serial.println(fahrenheit);

  if (fahrenheit > threshold){    // Czy temperatura przekroczyła wartość progową?
    digitalWrite(ledPin, HIGH);  // Jeśli tak, zapal diodę LED,
  } else {
    digitalWrite(ledPin, LOW);   // jeśli nie, zgaś diodę LED
  }
  delay(1000);

}
