// Szkic sprawdzający działanie czujnika prądu

// Numer pinu, do którego podłączony jest czujnik
#define CURRENT_SENSOR A0

// Zmienne do przechowywania wyników pomiarów
float amplitude_current;
float effective_value;
float effective_voltage = 230; // Ustaw napięcie 230V (Europa) lub 110V (USA)
float effective_power;
float zero_sensor;
                                         
void setup(void)
{
  // Inicjalizacja portu szeregowego
  Serial.begin(115200);
  
  // Kalibracja czujnika dla prądu zerowego
  zero_sensor = getSensorValue();
  Serial.print("Punkt zerowy czujnika: ");
  Serial.println(zero_sensor);
  Serial.println("");
  
}
  
void loop(void)
{
  
  // Pomiar 
  float sensor_value = getSensorValue();
  Serial.print("Wartosc odczytu: ");
  Serial.println(sensor_value);
    
  // Obliczanie wartości skutecznej natężenia prądu
  amplitude_current=(float)(abs(sensor_value-zero_sensor))/1024*5/185*1000000;
  effective_value=amplitude_current/1.414;
  
  // Wydruk wyników
  Serial.println("Amplituda pradu (mA): ");
  Serial.println(amplitude_current,1);
  Serial.println("Wartosc skuteczna pradu (mA)");
  Serial.println(effective_value,1);
  Serial.println("Moc (W): ");
  Serial.println(abs(effective_value*effective_voltage/1000),1);
  Serial.println("");
  
  // Przerwa 500ms
  delay(500);
  
}

// Funkcja pobierajaca dane z czujnika
float getSensorValue()
{
  int sensorValue;
  float avgSensor = 0;
  int nb_measurements = 100;
  for (int i = 0; i < nb_measurements; i++) {
    sensorValue = analogRead(CURRENT_SENSOR);
    avgSensor = avgSensor + float(sensorValue);
  }	  
  avgSensor = avgSensor/float(nb_measurements);
  return avgSensor;
}
