# Interfejs graficzny dla czujnika temperatury i modułu Bluetooth
#-*- coding: utf-8 -*-
# Importowanie
import time
import serial
from Tkinter import *

# Parametry portu szeregowego
serial_speed = 115200
serial_port = 'COM4'

# Sprawdź przy szeregowym połączeniu USB
# serial_port = '/dev/tty.usbmodem1421'

ser = serial.Serial(serial_port, serial_speed, timeout=1)

# Główna aplikacja Tkinter 
class Application(Frame):

	# Zleć czujnikowi wykonanie pomiaru
	def measure(self):

		# Zażądaj wyników i odczytaj odpowiedź
		ser.write("m")
		data = ser.readline()

		# Jeśli odpowiedź nie jest pusta, przetwórz ją i wyświetl 
		if (data != ""):
			processed_data = data.split(",")

			self.temp_data.set("Temperatura: " + str(processed_data[0]))
			self.temperature.pack()

			self.hum_data.set("Wilgotność: " + str(processed_data[1]))
			self.humidity.pack()

		# Zrób 1-sekundową przerwę między pomiarami
		self.after(1000,self.measure)

	# Utwórz elementy wyświetlane
	def createWidgets(self):

		self.temperature = Label(self, textvariable=self.temp_data, font=('Verdana', 40, 'bold'))
		self.temp_data.set("Temperatura")
		self.temperature.pack()

		
		self.humidity = Label(self, textvariable=self.hum_data, font=('Verdana', 40, 'bold'))
		self.hum_data.set("Wilgotność")
		self.humidity.pack()

	# Zainicjalizuj zmienne i rozpocznij pomiary
	def __init__(self, master=None):
		Frame.__init__(self, master)
		self.temp_data = StringVar()
		self.hum_data = StringVar()
		self.createWidgets()
		self.pack()
		self.measure()

# Utwórz i uruchom graficzny interfejs użytkownika
root = Tk()
app = Application(master=root)
app.mainloop()
