

#include <MozziGuts.h>
#include <Oscil.h> // Szablon oscylatora.
#include <tables/sin2048_int8.h> // Tabela wartości funkcji sinus oscylatora.

// Zastosuj: Oscil <table_size, update_rate> oscilName (wavetable)
Oscil <SIN2048_NUM_CELLS, AUDIO_RATE> aSin(SIN2048_DATA);

// Zastosuj #define dla CONTROL_RATE, a nie dla stałej.
#define CONTROL_RATE 64 // Wartość musi być potęgą liczby 2.

int trigPin = 11;
int echoPin = 12;


void setup()
{
  startMozzi(CONTROL_RATE); // Definiuje współczynnik sterujący równy 64 (wartość ta musi być potęgą liczby 2).
  aSin.setFreq(440); // Częstotliwość określa zmienna typu unsigned int lub float.
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
}


void updateControl()
{
  float s = takeSounding();
  aSin.setFreq(s);
}


int updateAudio()
{
  return aSin.next(); // Zwraca wartość sygnału typu int, która oscyluje wokół zera.
}


void loop()
{
  audioHook(); // Wymagane.
}


float takeSounding()
{
  digitalWrite(trigPin, LOW); 
  delayMicroseconds(2); 
  digitalWrite(trigPin, HIGH); 
  delayMicroseconds(10); 
  digitalWrite(trigPin, LOW); 
  delayMicroseconds(2); 
  int duration = pulseIn(echoPin, HIGH, 1000); 
  if (duration > 1000) duration = 1000;
  return (float)duration / 2.0;
}

