
// Arduino Uno R3 lub Leonardo (z płytką Ethernet)
#include "DHT.h"
#include <SPI.h>
#include <Ethernet.h>

// Adres MAC musi być unikalny (domyślna wartość nie powinna powodować problemów).
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };

EthernetServer server(80);
DHT dht;

const int plusPin = A5;
const int dataPin = A4;
const int ignorePin = A3;
const int gndPin = A2;

char line1[100];

void setup()
{
  pinMode(ignorePin, INPUT);
  pinMode(gndPin, OUTPUT);
  pinMode(plusPin, OUTPUT);
  digitalWrite(plusPin, HIGH);
  pinMode(dataPin, INPUT_PULLUP);
  Serial.begin(9600);
  while (!Serial){};
  connectToNetwork();
  server.begin();
  dht.setup(dataPin);
}

void connectToNetwork()
{
  if (Ethernet.begin(mac))
  {
    for (byte thisByte = 0; thisByte < 4; thisByte++)
    {
      Serial.print(Ethernet.localIP()[thisByte], DEC);
      Serial.print("."); 
    }
  }
  delay(3000);
}

void loop()
{
  EthernetClient client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      readHeader(client);
      if (! pageNameIs("/"))
      {
        client.stop();  
        return;
      }
      
      float tempC = dht.getTemperature();
      float tempF = tempC * 9.0 / 5.0 + 32.0;
      float humidity = dht.getHumidity();
      
      client.println("HTTP/1.1 200 OK");
      client.println("Content-Type: text/html");
      client.println();

      // Prześlij treść.
      client.println("<html>");
      client.println("<head><script>setTimeout((function(){window.location.reload(true);}), 1000)</script></head>");
      client.println("<body>");
      client.println("<h1>Czujniki</h1>");

      client.println("<table>");
      client.println("<tr><th>Temperatura (C)</th>");
      client.print("<td>"); client.print(tempC); client.println("</td>");
      client.println("</tr>");
      
      client.println("<tr><th>Temperatura (F)</th>");
      client.print("<td>"); client.print(tempF); client.println("</td>");
      client.println("</tr>");
      
      client.println("<tr><th>Wilgotnosc wzgledna</th>");
      client.print("<td>"); client.print(humidity); client.println("</td>");
      client.println("</tr>");
      
      client.println("</table></body></html>");

      client.stop();            
    }
  }
}


void readHeader(EthernetClient client)
{
  // Wczytaj pierwszą linie nagłówka.
  char ch;
  int i = 0;
  while (ch != '\n')
  {
    if (client.available())
    {
      ch = client.read();
      line1[i] = ch;
      i ++;
    }
  }
  line1[i] = '\0'; 
  Serial.println(line1);
}

boolean pageNameIs(char* name)
{
   // Nazwa strony rozpoczyna się od 4. znaku,
   // a kończy się spacją.
   int i = 4;
   char ch = line1[i];
   while (ch != ' ' && ch != '\n' && ch != '?')
   {
     if (name[i-4] != line1[i])
     {
       return false;
     }
     i++;
     ch = line1[i];
   }
   return true;
}

