// Rozdział 1. Wyświetlacz widmowy

const int MAX_MESSAGE_LEN = 40;
const int gap = 700;

const int sw1Pin = 11;
const int ledPins[] = {2, 3, 4, 5, 6, 7, 8};

char message[MAX_MESSAGE_LEN];

extern byte characters[96][7]; // Umożliwia późniejsze zdefiniowanie tablicy.

void setup()
{
  pinMode(sw1Pin, INPUT_PULLUP);
  for (int i = 0; i < 7; i++)
  {
    pinMode(ledPins[i], OUTPUT);
  }
  strcpy(message, "Arduino"); // Komunikat domyślny.
  Serial.begin(9600);
}

void loop()
{
  if (Serial.available())
  {
    int len = Serial.readBytesUntil(0, message, MAX_MESSAGE_LEN);
    message[len] = 0; // Znak kończący łańcuch.
  } 
  int n = strlen(message);
  if (digitalRead(sw1Pin) == LOW)
  {
    delayMicroseconds(gap * 10);
    // Wyświetl to!
    for (int i = n-1; i >= 0; i--)
    {
      displayChar(message[i]);
    }
  }
  delayMicroseconds(gap * n * 9);
}

inline void displayChar(char ch)
{
  if (ch >= 32 && ch <= 127)
  {
    for (int column = 0; column < 8; column++)
    {
      for (int row = 0; row < 7; row++)
      {
        byte rowByte = characters[ch - 32][row] >> 1;
        int pixel = bitRead(rowByte, column);
        digitalWrite(ledPins[row], pixel);
      }
      delayMicroseconds(gap);
    }
  }
  delayMicroseconds(gap * 2);
}    
        
        

byte characters[96][7] = {
  {
    //32 Spacja
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //33 Wykrzyknik !
    0b01000000,
    0b01000000,
    0b01000000,
    0b01000000,
    0b01000000,
    0b00000000,
    0b01000000
  },
  {
    //34 Cudzysłów "
    0b01010000,
    0b01010000,
    0b01010000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //35 Płotek #
    0b00000000,
    0b00000000,
    0b01010000,
    0b11111000,
    0b01010000,
    0b11111000,
    0b01010000
  },
  {
    //36 Dolar $
    0b00100000,
    0b01110000,
    0b10100000,
    0b01110000,
    0b00101000,
    0b01110000,
    0b00100000
  },
  {
    //37 Procent %
    0b01000000,
    0b10101000,
    0b01010000,
    0b00100000,
    0b01010000,
    0b10101000,
    0b00010000
  },
  {
    //38 Znak &
    0b00100000,
    0b01010000,
    0b10100000,
    0b01000000,
    0b10101000,
    0b10010000,
    0b01101000
  },
  {
    //39 Pojedynczy cudzysłów '
    0b01000000,
    0b01000000,
    0b01000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //40 Lewy nawias (
    0b00010000,
    0b00100000,
    0b01000000, 
    0b01000000,
    0b01000000,
    0b00100000,
    0b00010000
  },
  {
    //41 Prawy nawias )
    0b01000000,
    0b00100000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b00100000,
    0b01000000
  },
  {
    //42 Gwiazdka *
    0b00010000,
    0b00111000,
    0b00010000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //43 Plus +
    0b00000000,
    0b00100000,
    0b00100000,
    0b11111000,
    0b00100000,
    0b00100000,
    0b00000000
  },
  {
    //44 Przecinek ,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00010000,
    0b00010000
  },
  {
    //45 Minus -
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b11111000,
    0b00000000,
    0b00000000
  },
  {
    //46 Kropka .
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00010000
  },
  {
    // 47 Ukośnik lewy /
    0b00000000,
    0b00001000,
    0b00010000,
    0b00100000,
    0b01000000,
    0b10000000,
    0b00000000
  },
  {
    // 48 Zero
    0b01110000,
    0b10001000,
    0b10101000,
    0b10101000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //49 Jeden
    0b00100000,
    0b01100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b01110000,
    0b00000000
  },
  {
    //50 Dwa
    0b01110000,
    0b10001000,
    0b00010000,
    0b00100000,
    0b01000000,
    0b11111000,
    0b00000000
  },
  {
     //51 Trzy
    0b11111000,
    0b00010000,
    0b00100000,
    0b00010000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //52 cztery
    0b10010000,
    0b10010000,
    0b10010000,
    0b11111000,
    0b00010000,
    0b00010000,
    0b00000000
  },
  {
    //53 Pięć
    0b11111000,
    0b10000000,
    0b11110000,
    0b00001000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //54 Sześć
    0b01110000,
    0b10000000,
    0b11110000,
    0b10001000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //55 Siedem
    0b11111000,
    0b00001000,
    0b00010000,
    0b00100000,
    0b01000000,
    0b10000000,
    0b00000000
  },
  {
    //56 Osiem
    0b01110000,
    0b10001000,
    0b01110000,
    0b10001000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //57 Dziewięć
    0b01110000,
    0b10001000,
    0b10001000,
    0b01111000,
    0b00001000,
    0b01110000,
    0b00000000
  },
  {
    //58 :
    0b00000000,
    0b00000000,
    0b00100000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00100000
  },
  {
    //59 ;
    0b00000000,
    0b00000000,
    0b00100000,
    0b00000000,
    0b00100000,
    0b00100000,
    0b01000000
  },
  {
    //60 <
    0b00000000,
    0b00011000,
    0b01100000,
    0b10000000,
    0b01100000,
    0b00011000,
    0b00000000
  },
  {
    //61 =
    0b00000000,
    0b00000000,
    0b01111000,
    0b00000000,
    0b01111000,
    0b00000000,
    0b00000000
  },
  {
    //62 >
    0b00000000,
    0b11000000,
    0b00110000,
    0b00001000,
    0b00110000,
    0b11000000,
    0b00000000
  },
  {
    //63 ?
    0b01100000,
    0b10010000,
    0b00100000,
    0b00100000,
    0b00000000,
    0b00100000,
    0b00000000
  },
  {
    //64 @
    0b01110000,
    0b10001000,
    0b10011000,
    0b10101000,
    0b10010000,
    0b10001000,
    0b01110000
  },
  {
    //65 A
    0b00100000,
    0b01010000,
    0b10001000,
    0b11111000,
    0b10001000,
    0b10001000,
    0b00000000
  },
  {
    //B
    0b11110000,
    0b10001000,
    0b1111000,
    0b10001000,
    0b10001000,
    0b11110000,
    0b00000000
  },
  {
    //C
    0b01110000,
    0b10001000,
    0b10000000,
    0b10000000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //D
    0b11110000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b11110000,
    0b00000000
  },
  {
    //E
    0b11111000,
    0b10000000,
    0b11111000,
    0b10000000,
    0b10000000,
    0b11111000,
    0b00000000
  },
  {
    //F
    0b11111000,
    0b10000000,
    0b11110000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b00000000
  },
  {
    //G
    0b01110000,
    0b10001000,
    0b10000000,
    0b10011000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //H
    0b10001000,
    0b10001000,
    0b11111000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b00000000
  },
  {
    //I
    0b01110000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b01110000,
    0b00000000
  },
  {
    //J
    0b00111000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b10010000,
    0b01100000,
    0b00000000
  },
  {
    //K
    0b10001000,
    0b10010000,
    0b11100000,
    0b10100000,
    0b10010000,
    0b10001000,
    0b00000000
  },
  {
    //L
    0b10000000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b11111000,
    0b00000000
  },
  {
    //M
    0b10001000,
    0b11011000,
    0b10101000,
    0b10101000,
    0b10001000,
    0b10001000,
    0b00000000
  },
  {
    //N
    0b10001000,
    0b10001000,
    0b11001000,
    0b10101000,
    0b10011000,
    0b10001000,
    0b00000000
  },
  {
    //O
    0b01110000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //P
    0b11110000,
    0b10001000,
    0b11110000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b00000000
  },
  {
    //Q
    0b01110000,
    0b10001000,
    0b10001000,
    0b10101000,
    0b10010000,
    0b01101000,
    0b00000000
  },
  {
    //R
    0b11110000,
    0b10001000,
    0b11110000,
    0b10100000,
    0b10010000,
    0b10001000,
    0b00000000
  },
  {
    //S
    0b01111000,
    0b10000000,
    0b01110000,
    0b00001000,
    0b00001000,
    0b11110000,
    0b00000000
  },
  {
    //T
    0b11111000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
  },
  {
    //U
    0b10001000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b01110000,
    0b00000000
  },
  {
    //V
    0b10001000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b01010000,
    0b00100000,
    0b00000000
  },
  {
    //W
    0b10001000,
    0b10001000,
    0b10101000,
    0b10101000,
    0b10101000,
    0b01010000,
    0b00000000
  },
  {
    //X
    0b10001000,
    0b01010000,
    0b00100000,
    0b01010000,
    0b10001000,
    0b10001000,
    0b00000000
  },
  {
    //Y
    0b10001000,
    0b10001000,
    0b01010000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00000000
  },
  {
    //Z
    0b11111000,
    0b00001000,
    0b00010000,
    0b00100000,
    0b01000000,
    0b11111000,
    0b00000000
  },
  {
    //91 [
    0b11100000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b10000000,
    0b11100000,
    0b00000000
  },
  {
    //92 (ukośnik lewy)
    0b00000000,
    0b10000000,
    0b01000000,
    0b00100000,
    0b00010000,
    0b00001000,
    0b00000000
  },
  {
    //93 ]
    0b00111000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00001000,
    0b00111000,
    0b00000000
  },
  {
    //94 ^
    0b00100000,
    0b01010000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //95 _
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b11111000
  },
  {
    //96 `
    0b10000000,
    0b01000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  },
  {
    //97 a
    0b00000000,
    0b01100000,
    0b00010000,
    0b01110000,
    0b10010000,
    0b01100000,
    0b00000000
  },
  {
    //98 b
    0b10000000,
    0b10000000,
    0b11100000,
    0b10010000,
    0b10010000,
    0b11100000,
    0b00000000
  },
  {
    //99 c
    0b00000000,
    0b00000000,
    0b01110000,
    0b10000000,
    0b10000000,
    0b01110000,
    0b00000000
  },
  {
    // 100 d
    0b00010000,
    0b00010000,
    0b01110000,
    0b10010000,
    0b10010000,
    0b01110000,
    0b00000000
  },
  {
    //101 e
    0b00000000,
    0b01100000,
    0b10010000,
    0b11110000,
    0b10000000,
    0b01110000,
    0b00000000
  },
  {
    //102 f
    0b00110000,
    0b01000000,
    0b11100000,
    0b01000000,
    0b01000000,
    0b01000000,
    0b00000000
  },
  {
    //103 g
    0b00000000,
    0b01100000,
    0b10010000,
    0b01110000,
    0b00010000,
    0b00010000,
    0b01100000
  },
  {
    //104 h
    0b10000000,
    0b10000000,
    0b11100000,
    0b10010000,
    0b10010000,
    0b10010000,
    0b00000000
  },
  {
    //105 i
    0b00100000,
    0b00000000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b01110000,
    0b00000000
  },
  {
    //106 j
    0b00010000,
    0b00000000,
    0b00110000,
    0b00010000,
    0b00010000,
    0b00010000,
    0b01100000
  },
  {
    //107 k
    0b10000000,
    0b10010000,
    0b10100000,
    0b11000000,
    0b10100000,
    0b10010000,
    0b00000000
  },
  {
    //108 l
    0b01100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b01110000,
    0b00000000
  },
  {
    //109 m
    0b00000000,
    0b00000000,
    0b01010000,
    0b10101000,
    0b10101000,
    0b10101000,
    0b00000000
  },
  {
    //110 n
    0b00000000,
    0b00000000,
    0b11110000,
    0b10001000,
    0b10001000,
    0b10001000,
    0b00000000
  },
  {
    //111 o
    0b00000000,
    0b00000000,
    0b01100000,
    0b10010000,
    0b10010000,
    0b01100000,
    0b00000000
  },
  {
    //112 p
    0b00000000,
    0b00000000,
    0b01100000,
    0b10010000,
    0b11110000,
    0b10000000,
    0b10000000
  },
  {
    //113 q
    0b00000000,
    0b00000000,
    0b01100000,
    0b10010000,
    0b11110000,
    0b00010000,
    0b00010000
  },
  {
    //114 r
    0b00000000,
    0b00000000,
    0b10110000,
    0b01001000,
    0b01000000,
    0b01000000,
    0b00000000
  },
  {
    //115 s
    0b00000000,
    0b00110000,
    0b01000000,
    0b00100000,
    0b00010000,
    0b01100000,
    0b00000000
  },
  {
    //116 t
    0b01000000,
    0b01000000,
    0b11100000,
    0b01000000,
    0b01000000,
    0b01000000,
    0b00000000
  },
  {
    // 117u
    0b00000000,
    0b00000000,
    0b10010000,
    0b10010000,
    0b10010000,
    0b01100000,
    0b00000000
  },
  {
    //118 v
    0b00000000,
    0b00000000,
    0b10001000,
    0b10001000,
    0b01010000,
    0b00100000,
    0b00000000
  },
  {
    //119 w
    0b00000000,
    0b00000000,
    0b00000000,
    0b10101000,
    0b10101000,
    0b01010000,
    0b00000000
  },
  {
    //120 x
    0b00000000,
    0b10001000,
    0b01010000,
    0b00100000,
    0b01010000,
    0b10001000,
    0b00000000
  },
  {
    //121 y
    0b00000000,
    0b00000000,
    0b10010000,
    0b10010000,
    0b01100000,
    0b01000000,
    0b10000000
  },
  {
    //122 z
    0b00000000,
    0b00000000,
    0b11110000,
    0b00100000,
    0b01000000,
    0b11110000,
    0b00000000
  },
  {
    //123 {
    0b00100000,
    0b01000000,
    0b01000000,
    0b10000000,
    0b01000000,
    0b01000000,
    0b00100000
  },
  {
    //124 |
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000,
    0b00100000
  },
  {
    //125 }
    0b00100000,
    0b00010000,
    0b00010000,
    0b00001000,
    0b00010000, 
    0b00010000,
    0b00100000
  },
  {
    //126 ~
    0b00000000,
    0b00000000,
    0b01000000,
    0b10101000,
    0b00010000,
    0b00000000,
    0b00000000
  },
  {
    //127 DEL
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000,
    0b00000000
  }
};
        
