

#include <CapacitiveSensor.h>
#include <MozziGuts.h>
#include <Oscil.h> // Szablon generatora fali.
#include <tables/sin2048_int8.h> // Tabela wartosci funkcji sinus.

// Stosuj zapis: Oscil <rozmiar_tablicy, częstotliwosc_aktualizowania> nazwaOscylatora (tablicafali)
Oscil <SIN2048_NUM_CELLS, AUDIO_RATE> aSin(SIN2048_DATA);
CapacitiveSensor cs = CapacitiveSensor(11, 12);     

const float frequencyScaling = 1.0;

// Stosuj #define dla CONTROL_RATE, a nie dla stałej.
#define CONTROL_RATE 64 // Podawaj potęgli liczby 2.


void setup()
{
  Serial.begin(9600);
  startMozzi(CONTROL_RATE);
  aSin.setFreq(440);
}


void updateControl()
{
  float s = takeReading();
  aSin.setFreq(s);
}


int updateAudio()
{
  return aSin.next(); 
}

void loop()
{
  audioHook();
}


float takeReading()
{
  long reading = cs.capacitiveSensor(5);
  //Serial.println(reading);
  return float(reading) * frequencyScaling;
}
