<?php

require 'artykulymi/om/BaseNumerPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'numer' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class NumerPeer extends BaseNumerPeer {


    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = parent::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Numer();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }

    
    public static function przeliczArtykuly()
    {
        foreach (parent::doSelect(new Criteria()) as $obj) {
            $obj->przeliczArtykuly();
        }
    }
    
    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }

} // NumerPeer
