<?php


class TabelaPodrubryk extends SortColumns {



    public function __construct()
    {
    
        $this->columns = array(

            'podrubryka' => array(
                'order' => 'asc',
                'label' => 'Podrubryka',
                'column' => PodrubrykaPeer::PODRUBRYKA,
                'slug' => 'podrubryka',
                'sortable' => 'tak'
            ),
            'lart' => array(
                'order' => 'dsc',
                'label' => 'Liczba artykułów',
                'column' => PodrubrykaPeer::LICZBAARTYKULOW,
                'slug' => 'lart',
                'sortable' => 'tak'
            ),
            'lstr' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => PodrubrykaPeer::LICZBASTRON,
                'slug' => 'lstr',
                'sortable' => 'tak'
            ),
        );            
        
        $this->setIndex('podrubryka');
    }
    
    public function getCriteria()
    {


        $c = new Criteria();

        if ($this->columns[$this->index]['order'] == 'asc') {
            $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
        } else {
            $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
        }
        
        return $c;        
    }
    

}