<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'filmy/Aktor.php';

require_once 'slugs.inc.php';

Propel::init('filmy-conf.php');

require_once 'pomocnicze.inc.php';
$plk = file('filmy.txt');
shuffle($plk);
foreach ($plk as $linia) {
    $tmp = parsuj_film(trim($linia));
    
    $c = new Criteria();
    $c->add(FilmPeer::TYTUL, $tmp['tytul']);
    $film = FilmPeer::doSelectOne($c);
    if (!$film) {
        $film = new Film();
        $film->setTytul($tmp['tytul']);
        $film->setSlug(string2slug($tmp['tytul']));
        $film->save();
    }

    foreach ($tmp['aktorzy'] as $a) {
        $c = new Criteria();
        $c->add(AktorPeer::IMIE, $a['imie']);
        $c->add(AktorPeer::NAZWISKO, $a['nazwisko']);
        $aktor = AktorPeer::doSelectOne($c);
        if (!$aktor) {
            $aktor = new Aktor();
            $aktor->setImie($a['imie']);
            $aktor->setNazwisko($a['nazwisko']);
            $aktor->setSlug(string2slug($a['imie'] . ' ' . $a['nazwisko']));
            $aktor->save();
        }

        $fha = new FilmHasAktor();
        $fha->setFilm($film);
        $fha->setAktor($aktor);
        try {
            $fha->save();
        } catch (PropelException $e) {
            echo 'ERROR: ' . $e->getMessage() . '<br />';
        }

    }
}

