
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- artykul
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artykul`;


CREATE TABLE `artykul`
(
	`artykul_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`lid` TEXT,
	`spistresci` TEXT,
	`tresc` TEXT,
	`slug` VARCHAR(255),
	PRIMARY KEY (`artykul_id`),
	UNIQUE KEY `artykul_U_1` (`slug`(255))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
