<?php

require 'sklep/om/BaseKategoriaPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'kategoria' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    sklep
 */
class KategoriaPeer extends BaseKategoriaPeer {

    public static function wstaw($dane)
    {
        $tmp = new Kategoria();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }


    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
//        $criteria->addAscendingOrderByColumn(self::KATEGORIA_ID);                    
        $criteria->addAscendingOrderByColumn(self::SLUG);
        return parent::doSelect($criteria, $con);
    }


    static public function retrieveBySlug($dvd_id, $slug)
    {
        $c = new Criteria();
        $cton1 = $c->getNewCriterion(KategoriaPeer::SLUG, $slug);
        $cton2 = $c->getNewCriterion(KategoriaPeer::DVD_ID, $dvd_id);
        $cton1->addAnd($cton2);
        $c->add($cton1);    
        return parent::doSelectOne($c);
    }

} // KategoriaPeer
