<?php



class WskaznikNumeru extends Pointer
{

    protected function getFirst()
    {
        $c = new Criteria();
        $c->setLimit(1);
        $c->addAscendingOrderByColumn(RocznikPeer::ROK);
        $c->addAscendingOrderByColumn(NumerPeer::NUMER);
        $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);
        if ($tmp = NumerPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }    
    }
    
    
    protected function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();

            //rok rwny, a numer mniejszy
            $cton1 = $c->getNewCriterion(RocznikPeer::ROK, $this->ptr_current->getRocznik()->getRok());
            $cton2 = $c->getNewCriterion(NumerPeer::NUMER, $this->ptr_current->getNumer(), Criteria::LESS_THAN);
            $cton1->addAnd($cton2);
            
            
            //rok mniejszy
            $cton3 = $c->getNewCriterion(RocznikPeer::ROK, $this->ptr_current->getRocznik()->getRok(), Criteria::LESS_THAN);
            
            $cton1->addOr($cton3);
            
            $c->add($cton1);

            
            $c->setLimit(1);
            $c->addDescendingOrderByColumn(RocznikPeer::ROK);
            $c->addDescendingOrderByColumn(NumerPeer::NUMER);
            $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);
            
            
            if ($tmp = NumerPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };    
    }    
    
    protected function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();

            //rok rwny, a numer wikszy
            $cton1 = $c->getNewCriterion(RocznikPeer::ROK, $this->ptr_current->getRocznik()->getRok());
            $cton2 = $c->getNewCriterion(NumerPeer::NUMER, $this->ptr_current->getNumer(), Criteria::GREATER_THAN);
            $cton1->addAnd($cton2);


            //rok wikszy
            $cton3 = $c->getNewCriterion(RocznikPeer::ROK, $this->ptr_current->getRocznik()->getRok(), Criteria::GREATER_THAN);

            $cton1->addOr($cton3);

            $c->add($cton1);



            $c->setLimit(1);          
            $c->addAscendingOrderByColumn(RocznikPeer::ROK);
            $c->addAscendingOrderByColumn(NumerPeer::NUMER);
            $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);
            if ($tmp = NumerPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    protected function getLast()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(RocznikPeer::ROK);
        $c->addDescendingOrderByColumn(NumerPeer::NUMER);
        $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);
        if ($tmp = NumerPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }    
    }    
    
    



}