<?php


class TabelaAutorow extends SortColumns {



    public function __construct()
    {
    
        $this->columns = array(

            'in' => array(
                'order' => 'asc',
                'label' => 'Imię i nazwisko',
                'slug' => 'in',
                'sortable' => 'tak'
            ),
            'lart' => array(
                'order' => 'dsc',    
                'label' => 'Liczba artykułów',
                'column' => AutorPeer::LICZBAARTYKULOW,
                'slug' => 'lart',
                'sortable' => 'tak'
            ),
            'lstr' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => AutorPeer::LICZBASTRON,
                'slug' => 'lstr',
                'sortable' => 'tak'
            ),    
        );            
        
        $this->setIndex('in');

    
    }
    
    public function getCriteria()
    {
        $c = new Criteria();
        
        switch ($this->columns[$this->index]['slug']) {
        
        case 'in':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn(AutorPeer::NAZWISKO);
                $c->addAscendingOrderByColumn(AutorPeer::IMIE);
            } else {
                $c->addDescendingOrderByColumn(AutorPeer::NAZWISKO);
                $c->addDescendingOrderByColumn(AutorPeer::IMIE);
            }
            break;
        
        case 'lart':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;
            
        case 'lstr':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;
        
        }
        
        return $c;        
    }
    

}