<?php

/**
 * Base class that represents a row from the 'tabela' table.
 *
 * 
 *
 * @package    football2002.om
 */
abstract class BaseTabela extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        TabelaPeer
	 */
	protected static $peer;

	/**
	 * The value for the tabela_id field.
	 * @var        int
	 */
	protected $tabela_id;

	/**
	 * The value for the liga_id field.
	 * @var        int
	 */
	protected $liga_id;

	/**
	 * The value for the klub_id field.
	 * @var        int
	 */
	protected $klub_id;

	/**
	 * The value for the punkty field.
	 * @var        int
	 */
	protected $punkty;

	/**
	 * The value for the bramkistracone field.
	 * @var        int
	 */
	protected $bramkistracone;

	/**
	 * The value for the bramkizdobyte field.
	 * @var        int
	 */
	protected $bramkizdobyte;

	/**
	 * The value for the mecze field.
	 * @var        int
	 */
	protected $mecze;

	/**
	 * The value for the zwyciestwa field.
	 * @var        int
	 */
	protected $zwyciestwa;

	/**
	 * The value for the remisy field.
	 * @var        int
	 */
	protected $remisy;

	/**
	 * The value for the przegrane field.
	 * @var        int
	 */
	protected $przegrane;

	/**
	 * @var        Liga
	 */
	protected $aLiga;

	/**
	 * @var        Klub
	 */
	protected $aKlub;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseTabela object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [tabela_id] column value.
	 * 
	 * @return     int
	 */
	public function getTabelaId()
	{
		return $this->tabela_id;
	}

	/**
	 * Get the [liga_id] column value.
	 * 
	 * @return     int
	 */
	public function getLigaId()
	{
		return $this->liga_id;
	}

	/**
	 * Get the [klub_id] column value.
	 * 
	 * @return     int
	 */
	public function getKlubId()
	{
		return $this->klub_id;
	}

	/**
	 * Get the [punkty] column value.
	 * 
	 * @return     int
	 */
	public function getPunkty()
	{
		return $this->punkty;
	}

	/**
	 * Get the [bramkistracone] column value.
	 * 
	 * @return     int
	 */
	public function getBramkistracone()
	{
		return $this->bramkistracone;
	}

	/**
	 * Get the [bramkizdobyte] column value.
	 * 
	 * @return     int
	 */
	public function getBramkizdobyte()
	{
		return $this->bramkizdobyte;
	}

	/**
	 * Get the [mecze] column value.
	 * 
	 * @return     int
	 */
	public function getMecze()
	{
		return $this->mecze;
	}

	/**
	 * Get the [zwyciestwa] column value.
	 * 
	 * @return     int
	 */
	public function getZwyciestwa()
	{
		return $this->zwyciestwa;
	}

	/**
	 * Get the [remisy] column value.
	 * 
	 * @return     int
	 */
	public function getRemisy()
	{
		return $this->remisy;
	}

	/**
	 * Get the [przegrane] column value.
	 * 
	 * @return     int
	 */
	public function getPrzegrane()
	{
		return $this->przegrane;
	}

	/**
	 * Set the value of [tabela_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setTabelaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->tabela_id !== $v) {
			$this->tabela_id = $v;
			$this->modifiedColumns[] = TabelaPeer::TABELA_ID;
		}

		return $this;
	} // setTabelaId()

	/**
	 * Set the value of [liga_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setLigaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->liga_id !== $v) {
			$this->liga_id = $v;
			$this->modifiedColumns[] = TabelaPeer::LIGA_ID;
		}

		if ($this->aLiga !== null && $this->aLiga->getLigaId() !== $v) {
			$this->aLiga = null;
		}

		return $this;
	} // setLigaId()

	/**
	 * Set the value of [klub_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setKlubId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->klub_id !== $v) {
			$this->klub_id = $v;
			$this->modifiedColumns[] = TabelaPeer::KLUB_ID;
		}

		if ($this->aKlub !== null && $this->aKlub->getKlubId() !== $v) {
			$this->aKlub = null;
		}

		return $this;
	} // setKlubId()

	/**
	 * Set the value of [punkty] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setPunkty($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->punkty !== $v) {
			$this->punkty = $v;
			$this->modifiedColumns[] = TabelaPeer::PUNKTY;
		}

		return $this;
	} // setPunkty()

	/**
	 * Set the value of [bramkistracone] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setBramkistracone($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->bramkistracone !== $v) {
			$this->bramkistracone = $v;
			$this->modifiedColumns[] = TabelaPeer::BRAMKISTRACONE;
		}

		return $this;
	} // setBramkistracone()

	/**
	 * Set the value of [bramkizdobyte] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setBramkizdobyte($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->bramkizdobyte !== $v) {
			$this->bramkizdobyte = $v;
			$this->modifiedColumns[] = TabelaPeer::BRAMKIZDOBYTE;
		}

		return $this;
	} // setBramkizdobyte()

	/**
	 * Set the value of [mecze] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setMecze($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->mecze !== $v) {
			$this->mecze = $v;
			$this->modifiedColumns[] = TabelaPeer::MECZE;
		}

		return $this;
	} // setMecze()

	/**
	 * Set the value of [zwyciestwa] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setZwyciestwa($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->zwyciestwa !== $v) {
			$this->zwyciestwa = $v;
			$this->modifiedColumns[] = TabelaPeer::ZWYCIESTWA;
		}

		return $this;
	} // setZwyciestwa()

	/**
	 * Set the value of [remisy] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setRemisy($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->remisy !== $v) {
			$this->remisy = $v;
			$this->modifiedColumns[] = TabelaPeer::REMISY;
		}

		return $this;
	} // setRemisy()

	/**
	 * Set the value of [przegrane] column.
	 * 
	 * @param      int $v new value
	 * @return     Tabela The current object (for fluent API support)
	 */
	public function setPrzegrane($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->przegrane !== $v) {
			$this->przegrane = $v;
			$this->modifiedColumns[] = TabelaPeer::PRZEGRANE;
		}

		return $this;
	} // setPrzegrane()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->tabela_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->liga_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->klub_id = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->punkty = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->bramkistracone = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
			$this->bramkizdobyte = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
			$this->mecze = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
			$this->zwyciestwa = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
			$this->remisy = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
			$this->przegrane = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 10; // 10 = TabelaPeer::NUM_COLUMNS - TabelaPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Tabela object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aLiga !== null && $this->liga_id !== $this->aLiga->getLigaId()) {
			$this->aLiga = null;
		}
		if ($this->aKlub !== null && $this->klub_id !== $this->aKlub->getKlubId()) {
			$this->aKlub = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TabelaPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = TabelaPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aLiga = null;
			$this->aKlub = null;
		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TabelaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			TabelaPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TabelaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			TabelaPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aLiga !== null) {
				if ($this->aLiga->isModified() || $this->aLiga->isNew()) {
					$affectedRows += $this->aLiga->save($con);
				}
				$this->setLiga($this->aLiga);
			}

			if ($this->aKlub !== null) {
				if ($this->aKlub->isModified() || $this->aKlub->isNew()) {
					$affectedRows += $this->aKlub->save($con);
				}
				$this->setKlub($this->aKlub);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = TabelaPeer::TABELA_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TabelaPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setTabelaId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += TabelaPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aLiga !== null) {
				if (!$this->aLiga->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aLiga->getValidationFailures());
				}
			}

			if ($this->aKlub !== null) {
				if (!$this->aKlub->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aKlub->getValidationFailures());
				}
			}


			if (($retval = TabelaPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TabelaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getTabelaId();
				break;
			case 1:
				return $this->getLigaId();
				break;
			case 2:
				return $this->getKlubId();
				break;
			case 3:
				return $this->getPunkty();
				break;
			case 4:
				return $this->getBramkistracone();
				break;
			case 5:
				return $this->getBramkizdobyte();
				break;
			case 6:
				return $this->getMecze();
				break;
			case 7:
				return $this->getZwyciestwa();
				break;
			case 8:
				return $this->getRemisy();
				break;
			case 9:
				return $this->getPrzegrane();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = TabelaPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getTabelaId(),
			$keys[1] => $this->getLigaId(),
			$keys[2] => $this->getKlubId(),
			$keys[3] => $this->getPunkty(),
			$keys[4] => $this->getBramkistracone(),
			$keys[5] => $this->getBramkizdobyte(),
			$keys[6] => $this->getMecze(),
			$keys[7] => $this->getZwyciestwa(),
			$keys[8] => $this->getRemisy(),
			$keys[9] => $this->getPrzegrane(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TabelaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setTabelaId($value);
				break;
			case 1:
				$this->setLigaId($value);
				break;
			case 2:
				$this->setKlubId($value);
				break;
			case 3:
				$this->setPunkty($value);
				break;
			case 4:
				$this->setBramkistracone($value);
				break;
			case 5:
				$this->setBramkizdobyte($value);
				break;
			case 6:
				$this->setMecze($value);
				break;
			case 7:
				$this->setZwyciestwa($value);
				break;
			case 8:
				$this->setRemisy($value);
				break;
			case 9:
				$this->setPrzegrane($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TabelaPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setTabelaId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setLigaId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setKlubId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setPunkty($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setBramkistracone($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setBramkizdobyte($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setMecze($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setZwyciestwa($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setRemisy($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setPrzegrane($arr[$keys[9]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(TabelaPeer::DATABASE_NAME);

		if ($this->isColumnModified(TabelaPeer::TABELA_ID)) $criteria->add(TabelaPeer::TABELA_ID, $this->tabela_id);
		if ($this->isColumnModified(TabelaPeer::LIGA_ID)) $criteria->add(TabelaPeer::LIGA_ID, $this->liga_id);
		if ($this->isColumnModified(TabelaPeer::KLUB_ID)) $criteria->add(TabelaPeer::KLUB_ID, $this->klub_id);
		if ($this->isColumnModified(TabelaPeer::PUNKTY)) $criteria->add(TabelaPeer::PUNKTY, $this->punkty);
		if ($this->isColumnModified(TabelaPeer::BRAMKISTRACONE)) $criteria->add(TabelaPeer::BRAMKISTRACONE, $this->bramkistracone);
		if ($this->isColumnModified(TabelaPeer::BRAMKIZDOBYTE)) $criteria->add(TabelaPeer::BRAMKIZDOBYTE, $this->bramkizdobyte);
		if ($this->isColumnModified(TabelaPeer::MECZE)) $criteria->add(TabelaPeer::MECZE, $this->mecze);
		if ($this->isColumnModified(TabelaPeer::ZWYCIESTWA)) $criteria->add(TabelaPeer::ZWYCIESTWA, $this->zwyciestwa);
		if ($this->isColumnModified(TabelaPeer::REMISY)) $criteria->add(TabelaPeer::REMISY, $this->remisy);
		if ($this->isColumnModified(TabelaPeer::PRZEGRANE)) $criteria->add(TabelaPeer::PRZEGRANE, $this->przegrane);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TabelaPeer::DATABASE_NAME);

		$criteria->add(TabelaPeer::TABELA_ID, $this->tabela_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getTabelaId();
	}

	/**
	 * Generic method to set the primary key (tabela_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setTabelaId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Tabela (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setLigaId($this->liga_id);

		$copyObj->setKlubId($this->klub_id);

		$copyObj->setPunkty($this->punkty);

		$copyObj->setBramkistracone($this->bramkistracone);

		$copyObj->setBramkizdobyte($this->bramkizdobyte);

		$copyObj->setMecze($this->mecze);

		$copyObj->setZwyciestwa($this->zwyciestwa);

		$copyObj->setRemisy($this->remisy);

		$copyObj->setPrzegrane($this->przegrane);


		$copyObj->setNew(true);

		$copyObj->setTabelaId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Tabela Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     TabelaPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TabelaPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Liga object.
	 *
	 * @param      Liga $v
	 * @return     Tabela The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setLiga(Liga $v = null)
	{
		if ($v === null) {
			$this->setLigaId(NULL);
		} else {
			$this->setLigaId($v->getLigaId());
		}

		$this->aLiga = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Liga object, it will not be re-added.
		if ($v !== null) {
			$v->addTabela($this);
		}

		return $this;
	}


	/**
	 * Get the associated Liga object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Liga The associated Liga object.
	 * @throws     PropelException
	 */
	public function getLiga(PropelPDO $con = null)
	{
		if ($this->aLiga === null && ($this->liga_id !== null)) {
			$this->aLiga = LigaPeer::retrieveByPK($this->liga_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aLiga->addTabelas($this);
			 */
		}
		return $this->aLiga;
	}

	/**
	 * Declares an association between this object and a Klub object.
	 *
	 * @param      Klub $v
	 * @return     Tabela The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setKlub(Klub $v = null)
	{
		if ($v === null) {
			$this->setKlubId(NULL);
		} else {
			$this->setKlubId($v->getKlubId());
		}

		$this->aKlub = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Klub object, it will not be re-added.
		if ($v !== null) {
			$v->addTabela($this);
		}

		return $this;
	}


	/**
	 * Get the associated Klub object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Klub The associated Klub object.
	 * @throws     PropelException
	 */
	public function getKlub(PropelPDO $con = null)
	{
		if ($this->aKlub === null && ($this->klub_id !== null)) {
			$this->aKlub = KlubPeer::retrieveByPK($this->klub_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aKlub->addTabelas($this);
			 */
		}
		return $this->aKlub;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
		} // if ($deep)

			$this->aLiga = null;
			$this->aKlub = null;
	}

} // BaseTabela
