<?php


/**
 * This class adds structure of 'mecz' table to 'football2002' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    football2002.map
 */
class MeczMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'football2002.map.MeczMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(MeczPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(MeczPeer::TABLE_NAME);
		$tMap->setPhpName('Mecz');
		$tMap->setClassname('Mecz');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('MECZ_ID', 'MeczId', 'INTEGER', true, null);

		$tMap->addForeignKey('GOSPODARZ', 'Gospodarz', 'INTEGER', 'klub', 'KLUB_ID', false, null);

		$tMap->addForeignKey('GOSC', 'Gosc', 'INTEGER', 'klub', 'KLUB_ID', false, null);

		$tMap->addColumn('KOLEJKA', 'Kolejka', 'INTEGER', false, null);

		$tMap->addColumn('GOL1', 'Gol1', 'INTEGER', false, null);

		$tMap->addColumn('GOL2', 'Gol2', 'INTEGER', false, null);

		$tMap->addColumn('DATA', 'Data', 'TIMESTAMP', false, null);

	} // doBuild()

} // MeczMapBuilder
