<?php

function aktualizuj_kursy($url)
{
    $kursy = simplexml_load_file($url);
    $c = new Criteria();
    $c->add(TabelaPeer::NUMERTABELI, $kursy->numer_tabeli);

    $tabela = TabelaPeer::doSelectOne($c);
    if (!$tabela) {
        $tabela = new Tabela();
        $tabela->setNumertabeli($kursy->numer_tabeli);
        $tabela->setDatapublikacji($kursy->data_publikacji);
        $tabela->setSlug(string2slug($kursy->numer_tabeli));
        $tabela->save();
        
        foreach ($kursy->pozycja as $pozycja) {
            $c = new Criteria();
            $c->add(WalutaPeer::KOD, $pozycja->kod_waluty);
            $waluta = WalutaPeer::doSelectOne($c);
            if (!$waluta) {
                $waluta = new Waluta();
                $waluta->setKod($pozycja->kod_waluty);
                $waluta->setNazwa($pozycja->nazwa_waluty);
                $waluta->setPrzelicznik($pozycja->przelicznik);
                $waluta->setSlug(string2slug($pozycja->kod_waluty));
                $waluta->save();
            }
            $kurs = new Kurs();
            $kurs->setWaluta($waluta);
            $kurs->setTabela($tabela);
            $kurs->setKurssredni(str_replace(',', '.', $pozycja->kurs_sredni));
            $kurs->save();
        }
    }
}

